import {LOYALTY_CARDS_TRAVELER_TO_ORDER_MATCH} from 'projects/trains/lib/order/traveler/constants';
import {TRAIN_BONUS_CARDS} from 'projects/trains/constants/bonusCards';

import {ITrainsLoyaltyCard} from 'server/api/TrainsApi/types/ITrainsLoyaltyCard';
import {IBonusCardDTO} from 'server/api/TravelersApi/types/IBonusCardDTO';
import {isNotNull} from 'types/utilities';

/*
 * Функция принимает существующие бонусные карты пассажира в записной книжке,
 * бонусные карты, которые ввели на шаге ввода данных и возвращает:
 * какие бонусные карты надо создать в записной книжке, а какие удалить.
 */
export default function getTravelerPassengerLoyaltyCardsToCreateAndDelete(
    availableLoyaltyCards: TRAIN_BONUS_CARDS[],
    orderPassengerLoyaltyCards: (ITrainsLoyaltyCard | null)[],
    travelerPassengerLoyaltyCards: IBonusCardDTO[],
): {
    loyaltyCardsToCreate: ITrainsLoyaltyCard[];
    loyaltyCardsToDelete: IBonusCardDTO[];
} {
    const loyaltyCardsToCreate: ITrainsLoyaltyCard[] =
        orderPassengerLoyaltyCards.filter(isNotNull);
    const loyaltyCardsToDelete: IBonusCardDTO[] = [];

    travelerPassengerLoyaltyCards.forEach(travelPassengerLoyaltyCard => {
        const existedLoyaltyCardIndex = loyaltyCardsToCreate.findIndex(
            loyaltyCardToCreate =>
                loyaltyCardToCreate &&
                loyaltyCardToCreate.type ===
                    LOYALTY_CARDS_TRAVELER_TO_ORDER_MATCH[
                        travelPassengerLoyaltyCard.type
                    ] &&
                loyaltyCardToCreate.number ===
                    travelPassengerLoyaltyCard.number,
        );

        if (existedLoyaltyCardIndex === -1) {
            if (
                availableLoyaltyCards.includes(
                    LOYALTY_CARDS_TRAVELER_TO_ORDER_MATCH[
                        travelPassengerLoyaltyCard.type
                    ] as TRAIN_BONUS_CARDS,
                )
            ) {
                loyaltyCardsToDelete.push(travelPassengerLoyaltyCard);
            }
        } else {
            loyaltyCardsToCreate.splice(existedLoyaltyCardIndex, 1);
        }
    });

    return {
        loyaltyCardsToCreate,
        loyaltyCardsToDelete,
    };
}
