import {EDocumentType} from 'constants/document/documentTypes';

import {ISaveDocumentToTravelerNotebookPassenger} from '../types/common';

import {DOCUMENTS_TRAVELERS_KEYS} from 'projects/trains/lib/order/passengers/documentTypes';
import {replaceSpecialSymbols} from 'projects/trains/lib/order/fields/document';
import {isPatronymicEmpty} from 'projects/trains/lib/order/fields/patronymic';
import {getDocumentFullTitle} from 'projects/trains/lib/order/fields/utils';

export interface IPreparedStoreDocument {
    title: string;
    type: EDocumentType;
    number: string;
    firstName: string;
    middleName: string;
    lastName: string;
    citizenship: number;
    validDate?: string;
}

/*
 * Преобразование данных документа пассажира для отправки в записную книжку.
 */
export default function prepareDocumentToStore(
    passenger: ISaveDocumentToTravelerNotebookPassenger,
): IPreparedStoreDocument {
    const {docType, patronymic} = passenger;

    return {
        title: getDocumentFullTitle(docType),
        type: DOCUMENTS_TRAVELERS_KEYS[docType],
        number: replaceSpecialSymbols(passenger.docId || '', docType),
        firstName: passenger.firstName,
        middleName: isPatronymicEmpty(patronymic) ? '' : patronymic,
        lastName: passenger.lastName,
        citizenship: passenger.citizenshipGeoId,
        validDate: passenger.docValidDate,
    };
}
