import IToursService from 'server/services/ToursService/types/IToursService';
import IGetToursWidgetInfoApiResponse from 'server/api/ToursApi/types/IGetToursWidgetInfoApiResponse';
import IBindToursApiRequestParams from 'server/api/ToursApi/types/IBindToursApiRequestParams';
import {TBindToursApiResponse} from 'server/api/ToursApi/types/TBindToursApiResponse';

import {HotelsMetaParamsBuilder} from 'server/utilities/hotels/HotelsMetaParamsBuilder/HotelsMetaParamsBuilder';

import {IDependencies} from 'server/getContainerConfig';
import {ToursApi} from 'server/api/ToursApi/ToursApi';

export class ToursService implements IToursService {
    private toursApi: ToursApi;
    private hotelsMetaParamsBuilder: HotelsMetaParamsBuilder;

    constructor({toursApi, hotelsMetaParamsBuilder}: IDependencies) {
        this.toursApi = toursApi;
        this.hotelsMetaParamsBuilder = hotelsMetaParamsBuilder;
    }

    async getToursWidgetInfo(): Promise<IGetToursWidgetInfoApiResponse> {
        const attributionParams =
            this.hotelsMetaParamsBuilder.getAttributionParams();

        return this.toursApi.getToursWidgetInfo(attributionParams);
    }

    async bindTour(
        params: IBindToursApiRequestParams,
    ): Promise<TBindToursApiResponse> {
        const attributionParams =
            this.hotelsMetaParamsBuilder.getAttributionParams();

        return this.toursApi.bindTour({...attributionParams, ...params});
    }
}
