import {
    EFirmTrainAdvantageIcon,
    EFirmTrainBlock,
} from 'types/trains/seoPages/firmTrain/TFirmTrainBlock';
import {ETextBlocksType} from 'types/common/seoPages/ITextBlocks';
import {ITrainsGetFirmTrainServiceResponse} from 'server/services/TrainsService/types/ITrainsGetFirmTrainService/ITrainsGetFirmTrainServiceResponse';

const getLastochkaFirmTrainResponse200: ITrainsGetFirmTrainServiceResponse = {
    seoInfo: {
        openGraph: {
            image: '',
            imageSize: {
                width: 1920,
                height: 469,
            },
            title: 'Купить билеты на Ласточку',
            description:
                'Ласточка — цены, расписание и время в пути. Приобрести билеты онлайн туда и обратно.',
        },
        schemaOrg: {
            faqItems: [
                {
                    question: 'Как купить дешевый билет?',
                    answer: 'Цена на билет зависит от дальности и направления маршрута. Чем раньше вы решите купить билет, тем ниже будет его цена. Нужно учесть, что некоторые места в «Ласточке» — откидные. Их стоимость меньше обычных, но они могут быть не совсем комфортны для дальних поездок.',
                },
                {
                    question: 'Когда открываются продажи билетов?',
                    answer: 'Билеты на «Ласточку» можно купить за 90 дней до отправления.',
                },
                {
                    question: 'Как выбрать место в вагоне?',
                    answer: 'Все места в «Ласточке» — сидячие. Они расположены рядами по два и три сиденья в каждом. Нечетные номера находятся у окон, все остальные места — четные.',
                },
            ],
        },
        description:
            'Ласточка — цены, расписание и время в пути. Приобрести билеты онлайн туда и обратно.',
        title: 'Купить билеты на Ласточку',
    },
    blocks: [
        {
            type: EFirmTrainBlock.SEARCH_FORM,
            data: {
                title: 'Билеты на Ласточку',
                imageUrl: '',
            },
        },
        {
            type: EFirmTrainBlock.DESCRIPTION,
            data: {
                title: 'Скоростной электропоезд «Ласточка»',
                text: {
                    type: ETextBlocksType.textBlock,
                    children: [
                        {
                            type: ETextBlocksType.plainTextBlock,
                            data: {
                                text: 'Поезд перевозит пассажиров между десятками российских городов. Это распространенный способ передвижения не только у нас, но и в 17 других странах. Поезд состоит из пяти вагонов, максимальная скорость — до 160 км⁠/⁠ч.',
                            },
                        },
                    ],
                },
            },
        },
        {
            type: EFirmTrainBlock.ADVANTAGES,
            data: {
                items: [
                    {
                        title: 'Вместительность',
                        text: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'В пяти вагонах могут ехать 453 человека, но на некоторых маршрутах количество вагонов удваивается, и число пассажиров может достичь 906',
                                    },
                                },
                            ],
                        },
                        iconType: EFirmTrainAdvantageIcon.PEOPLE,
                    },
                    {
                        title: 'Комфорт',
                        text: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'Оптимальную температуру в вагонах поддерживают современные системы климат⁠-⁠контроля, поэтому поезд может совершать поездки при температуре от −⁠40 до +⁠40⁠°⁠C. В первом и последнем вагонах есть биотуалеты, часть мест оснащена розетками.',
                                    },
                                },
                            ],
                        },
                        iconType: EFirmTrainAdvantageIcon.CLIMATE,
                    },
                    {
                        title: 'Мощность',
                        text: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'В каждом головном вагоне установлены четыре электродвигателя мощностью 320 кВт. Каждый из них в три раза превосходит двигатель среднего автомобиля.',
                                    },
                                },
                            ],
                        },
                        iconType: EFirmTrainAdvantageIcon.ENERGY,
                    },
                ],
            },
        },
        {
            type: EFirmTrainBlock.FAQ,
            data: {
                title: 'Частые вопросы о поезде «Ласточка»',
                items: [
                    {
                        title: 'Как купить дешевый билет?',
                        text: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'Цена на билет зависит от дальности и направления маршрута. Чем раньше вы решите купить билет, тем ниже будет его цена. Нужно учесть, что некоторые места в «Ласточке» — откидные. Их стоимость меньше обычных, но они могут быть не совсем комфортны для дальних поездок.',
                                    },
                                },
                            ],
                        },
                    },
                    {
                        title: 'Когда открываются продажи билетов?',
                        text: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'Билеты на «Ласточку» можно купить за 90 дней до отправления.',
                                    },
                                },
                            ],
                        },
                    },
                    {
                        title: 'Как выбрать место в вагоне?',
                        text: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'Все места в «Ласточке» — сидячие. Они расположены рядами по два и три сиденья в каждом. Нечетные номера находятся у окон, все остальные места — четные.',
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
};

export default getLastochkaFirmTrainResponse200;
