import {
    EFirmTrainAdvantageIcon,
    EFirmTrainBlock,
} from 'types/trains/seoPages/firmTrain/TFirmTrainBlock';
import {ETextBlocksType} from 'types/common/seoPages/ITextBlocks';
import {ITrainsGetFirmTrainServiceResponse} from 'server/services/TrainsService/types/ITrainsGetFirmTrainService/ITrainsGetFirmTrainServiceResponse';

const getStrizhFirmTrainResponse200: ITrainsGetFirmTrainServiceResponse = {
    seoInfo: {
        openGraph: {
            image: '',
            imageSize: {
                width: 1920,
                height: 469,
            },
            title: 'Купить билеты на Стриж',
            description:
                'Стриж — цены, расписание и время в пути. Приобрести билеты онлайн туда и обратно.',
        },
        schemaOrg: {
            faqItems: [
                {
                    question: 'Сколько вагонов в поезде?',
                    answer: 'В «Стриже» может быть максимум 20 вагонов. Общая вместимость достигает 414 пассажиров.',
                },
                {
                    question: 'Когда открываются продажи билетов?',
                    answer: 'Билеты на «Стриж» можно купить за 90 дней до отправления.',
                },
                {
                    question: 'Какая скорость у поезда?',
                    answer: 'Средняя скорость движения — 160 км/ч, но конструкция поезда предусматривает разгон до 200 км/ч.',
                },
            ],
        },
        description:
            'Стриж — цены, расписание и время в пути. Приобрести билеты онлайн туда и обратно.',
        title: 'Купить билеты на Стриж',
    },
    blocks: [
        {
            type: EFirmTrainBlock.SEARCH_FORM,
            data: {
                title: 'Билеты на Стриж',
                imageUrl: '',
            },
        },
        {
            type: EFirmTrainBlock.DESCRIPTION,
            data: {
                title: 'Скоростной поезд «Стриж»',
                text: {
                    type: ETextBlocksType.textBlock,
                    children: [
                        {
                            type: ETextBlocksType.plainTextBlock,
                            data: {
                                text: 'Поезд курсирует между Москвой и Нижним Новгородом, Санкт⁠-⁠Петербургом и Самарой, а также между Москвой и Санкт⁠-⁠Петербургом. Маршрут между Москвой и Берлином был временно приостановлен из⁠-⁠за ограничительных мер в 2020 году.',
                            },
                        },
                    ],
                },
            },
        },
        {
            type: EFirmTrainBlock.ADVANTAGES,
            data: {
                items: [
                    {
                        title: 'Вагоны',
                        text: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'На короткие маршруты «Стрижа» можно купить билеты в вагон с сидячими местами или в люксовый спальный вагон. На время дальних маршрутов к составу поезда присоединяются купейные вагоны и СВ. Кроме того, в «Стриже» предусмотрены вагон⁠-⁠ресторан и вагон⁠-⁠буфет.',
                                    },
                                },
                            ],
                        },
                        iconType: EFirmTrainAdvantageIcon.COMFORT,
                    },
                    {
                        title: 'Конструкция',
                        text: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'В «Стриже» есть особая система маятникового наклона кузова. Благодаря ей можно проходить небольшие повороты на высокой скорости, не нарушая комфорт пассажиров.',
                                    },
                                },
                            ],
                        },
                        iconType: EFirmTrainAdvantageIcon.TRAIN,
                    },
                    {
                        title: 'Комфорт',
                        text: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'Все пассажирские вагоны оснащены современными системами кондиционирования и электрического отопления. В люксовых вагонах в каждом купе установлены туалеты и душевые кабины. В поезде есть специальные купе для людей с ограниченными возможностями.',
                                    },
                                },
                            ],
                        },
                        iconType: EFirmTrainAdvantageIcon.TEMPERATURE,
                    },
                ],
            },
        },
        {
            type: EFirmTrainBlock.FAQ,
            data: {
                title: 'Частые вопросы о поезде «Стриж»',
                items: [
                    {
                        title: 'Сколько вагонов в поезде?',
                        text: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'В «Стриже» может быть максимум 20 вагонов. Общая вместимость достигает 414 пассажиров.',
                                    },
                                },
                            ],
                        },
                    },
                    {
                        title: 'Когда открываются продажи билетов?',
                        text: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'Билеты на «Стриж» можно купить за 90 дней до отправления.',
                                    },
                                },
                            ],
                        },
                    },
                    {
                        title: 'Какая скорость у поезда?',
                        text: {
                            type: ETextBlocksType.textBlock,
                            children: [
                                {
                                    type: ETextBlocksType.plainTextBlock,
                                    data: {
                                        text: 'Средняя скорость движения — 160 км⁠/⁠ч, но конструкция поезда предусматривает разгон до 200 км⁠/⁠ч.',
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
};

export default getStrizhFirmTrainResponse200;
