import {ERoutePolicy} from 'projects/trains/constants/routePolicy';
import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';
import {TRAIN_BONUS_CARDS} from 'projects/trains/constants/bonusCards';
import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';
import {GENDER_TYPE} from 'projects/trains/constants/genders';
import {PLACE_RESERVATION_TYPE} from 'projects/trains/constants/placeReservationType';

import {
    ISchemaPlaceFlags,
    TrainPlaceType,
    TrainsTariffCategoryCode,
} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';
import {ITrainsDetailsInfoServiceResponse} from '../types/ITrainsDetailsInfoServiceResponse';
import {TrainBookedTariffCode} from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoTicket';

import {CurrencyType} from 'utilities/currency/CurrencyType';

const trainDetails: ITrainsDetailsInfoServiceResponse = {
    trainDetails: {
        isCovidCertificateRequired: true,
        provider: 'P1',
        arrival: '2020-06-13T09:05:00+03:00',
        imFinalStationName: 'С-ПЕТЕР-ГЛ',
        electronicTicket: true,
        allowedDocumentTypes: [
            TRAINS_DOCUMENT_TYPES.FOREIGN_DOCUMENT,
            TRAINS_DOCUMENT_TYPES.RUSSIAN_INTERNATIONAL_PASSPORT,
            TRAINS_DOCUMENT_TYPES.RUSSIAN_PASSPORT,
            TRAINS_DOCUMENT_TYPES.BIRTH_CERTIFICATE,
            TRAINS_DOCUMENT_TYPES.MILITARY_CARD,
            TRAINS_DOCUMENT_TYPES.SAILOR_PASSPORT,
        ],
        rawTrainName: '',
        isFirm: true,
        ticketNumber: '060Г',
        rawTrainCategory: 'СК ФИРМ',
        departure: '2020-06-13T00:33:00+03:00',
        isSuburban: false,
        coaches: [
            {
                adultTariff: {currency: CurrencyType.RUB, value: 3006.77},
                loyaltyCards: [TRAIN_BONUS_CARDS.BONUS_CARD],
                feeCalculationToken: 'sdfds',
                schemaId: 3,
                number: '03',
                facilities: ['BED'],
                hasDynamicPricing: true,
                directionConfirmed: false,
                owner: 'ФПК',
                placeCounts: {
                    upperSide: 0,
                    lowerSide: 0,
                    total: 18,
                    upperCoupe: 7,
                    lowerCoupe: 11,
                },
                canChooseBedding: false,
                placesByType: null,
                trainStartNumber: '059Г',
                type: TRAIN_COACH_TYPE.COMPARTMENT,
                arrival: '2020-06-13T09:05:00+03:00',
                serviceClass: {
                    internationalCode: '',
                    code: '2Ф',
                    description: '',
                    title: '',
                    key: '2Ф',
                },
                twoStorey: false,
                placesByCompartment: [
                    [12],
                    [14, 16],
                    [24],
                    [26],
                    [32],
                    [36],
                    [1],
                    [5],
                    [9, 11],
                    [15],
                    [21, 23],
                    [27],
                    [29],
                    [33, 35],
                ],
                petsAllowed: false,
                reservationVariants: null,
                electronicTicket: true,
                throughArrival: null,
                petInCoach: false,
                places: [
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3006.77,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 12,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1306.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3006.77,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 14,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1306.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3006.77,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 16,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1306.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3006.77,
                        },
                        gender: GENDER_TYPE.MALE,
                        number: 24,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1306.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3006.77,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 26,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1306.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3006.77,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 32,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1306.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3006.77,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 36,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1306.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 4750.8,
                        },
                        gender: GENDER_TYPE.MALE,
                        number: 1,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1916.75,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 4750.8,
                        },
                        gender: GENDER_TYPE.MALE,
                        number: 5,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1916.75,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 4750.8,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 9,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1916.75,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 4750.8,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 11,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1916.75,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 4750.8,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 15,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1916.75,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 4750.8,
                        },
                        gender: GENDER_TYPE.MALE,
                        number: 21,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1916.75,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 4750.8,
                        },
                        gender: GENDER_TYPE.MALE,
                        number: 23,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1916.75,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 4750.8,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 27,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1916.75,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 4750.8,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 29,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1916.75,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 4750.8,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 33,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1916.75,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 4750.8,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 35,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1916.75,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                ],
                hasNonRefundableTariff: false,
                placeRequirementsAvailable: false,
                tariffsInfo: [
                    {
                        minAge: 0,
                        title: 'Детский без места',
                        minAgeIncludesBirthday: false,
                        maxAge: 5,
                        withoutPlace: true,
                        code: TrainBookedTariffCode.BABY,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 0,
                        title: 'Детский',
                        minAgeIncludesBirthday: false,
                        maxAge: 10,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 10,
                        title: 'Детский 10-18',
                        minAgeIncludesBirthday: false,
                        maxAge: 18,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD_17,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                    {
                        minAge: 0,
                        title: 'Полный',
                        minAgeIncludesBirthday: false,
                        maxAge: 150,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.FULL,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                ],
                placeReservationType: PLACE_RESERVATION_TYPE.USUAL,
                petsSegregated: false,
                beddingTariff: {currency: CurrencyType.RUB, value: 0},
                isFirm: true,
                coachSubtypeCode: '66К',
                category: {value: 'compartment', title: 'купе'},
                index: 10,
            },
            {
                adultTariff: {currency: CurrencyType.RUB, value: 2482.4},
                loyaltyCards: [],
                feeCalculationToken: 'sdfds',
                schemaId: 3,
                number: '05',
                facilities: [
                    'COND',
                    'WC',
                    'TV',
                    'SAN',
                    'PAP',
                    'HSWR',
                    'S220',
                    'SLPR',
                    'PETS',
                ],
                hasDynamicPricing: true,
                directionConfirmed: false,
                owner: 'ТКС',
                placeCounts: {
                    upperSide: 0,
                    lowerSide: 0,
                    total: 13,
                    upperCoupe: 3,
                    lowerCoupe: 10,
                },
                canChooseBedding: false,
                placesByType: null,
                trainStartNumber: '059Г',
                type: TRAIN_COACH_TYPE.COMPARTMENT,
                arrival: '2020-06-13T09:05:00+03:00',
                serviceClass: {
                    internationalCode: '',
                    code: '2Л',
                    description:
                        'Кондиционер, биотуалет, душ в вагоне. В стоимость проезда входят: вода, пресса, душ, дорожный набор (зубная щётка, зубная паста, салфетки), тапочки, подарок для детей, бельё, ТВ, розетка, сейф, манеж для детей и дуга безопасности (по запросу). Питание за дополнительную плату.',
                    title: 'Комфорт',
                    key: '2Л',
                },
                twoStorey: false,
                placesByCompartment: [
                    [28],
                    [30, 32],
                    [3],
                    [5, 7],
                    [13, 15],
                    [17, 19],
                    [21, 23],
                    [31],
                ],
                petsAllowed: true,
                reservationVariants: null,
                electronicTicket: true,
                throughArrival: null,
                petInCoach: true,
                places: [
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2482.4,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 28,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1122.09,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2482.4,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 30,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1122.09,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2482.4,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 32,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1122.09,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3877.67,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 3,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1610.43,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3877.67,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 5,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1610.43,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3877.67,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 7,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1610.43,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3877.67,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 13,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1610.43,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3877.67,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 15,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1610.43,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3877.67,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 17,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1610.43,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3877.67,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 19,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1610.43,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3877.67,
                        },
                        gender: GENDER_TYPE.MALE,
                        number: 21,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1610.43,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3877.67,
                        },
                        gender: GENDER_TYPE.MALE,
                        number: 23,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1610.43,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3877.67,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 31,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1610.43,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                ],
                hasNonRefundableTariff: false,
                placeRequirementsAvailable: false,
                tariffsInfo: [
                    {
                        minAge: 0,
                        title: 'Детский без места',
                        minAgeIncludesBirthday: false,
                        maxAge: 5,
                        withoutPlace: true,
                        code: TrainBookedTariffCode.BABY,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 0,
                        title: 'Детский',
                        minAgeIncludesBirthday: false,
                        maxAge: 10,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 10,
                        title: 'Детский 10-18',
                        minAgeIncludesBirthday: false,
                        maxAge: 18,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD_17,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                    {
                        minAge: 0,
                        title: 'Полный',
                        minAgeIncludesBirthday: false,
                        maxAge: 150,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.FULL,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                ],
                placeReservationType: PLACE_RESERVATION_TYPE.USUAL,
                petsSegregated: false,
                beddingTariff: {currency: CurrencyType.RUB, value: 0},
                isFirm: true,
                coachSubtypeCode: '66К',
                category: {value: 'compartment', title: 'купе'},
                index: 11,
            },
            {
                adultTariff: {currency: CurrencyType.RUB, value: 3006.77},
                loyaltyCards: [TRAIN_BONUS_CARDS.BONUS_CARD],
                feeCalculationToken: 'sdfds',
                schemaId: 3,
                number: '09',
                facilities: ['BED'],
                hasDynamicPricing: true,
                directionConfirmed: false,
                owner: 'ФПК',
                placeCounts: {
                    upperSide: 0,
                    lowerSide: 0,
                    total: 4,
                    upperCoupe: 1,
                    lowerCoupe: 3,
                },
                canChooseBedding: false,
                placesByType: null,
                trainStartNumber: '059Г',
                type: TRAIN_COACH_TYPE.COMPARTMENT,
                arrival: '2020-06-13T09:05:00+03:00',
                serviceClass: {
                    internationalCode: '',
                    code: '2Ф',
                    description: '',
                    title: '',
                    key: '2Ф',
                },
                twoStorey: false,
                placesByCompartment: [[10], [7], [9, 11]],
                petsAllowed: false,
                reservationVariants: null,
                electronicTicket: true,
                throughArrival: null,
                petInCoach: false,
                places: [
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3006.77,
                        },
                        gender: null,
                        number: 10,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1306.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 4750.8,
                        },
                        gender: null,
                        number: 7,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1916.75,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 4750.8,
                        },
                        gender: null,
                        number: 9,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1916.75,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 4750.8,
                        },
                        gender: null,
                        number: 11,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1916.75,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                ],
                hasNonRefundableTariff: false,
                placeRequirementsAvailable: false,
                tariffsInfo: [
                    {
                        minAge: 0,
                        title: 'Детский без места',
                        minAgeIncludesBirthday: false,
                        maxAge: 5,
                        withoutPlace: true,
                        code: TrainBookedTariffCode.BABY,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 0,
                        title: 'Детский',
                        minAgeIncludesBirthday: false,
                        maxAge: 10,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 10,
                        title: 'Детский 10-18',
                        minAgeIncludesBirthday: false,
                        maxAge: 18,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD_17,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                    {
                        minAge: 0,
                        title: 'Полный',
                        minAgeIncludesBirthday: false,
                        maxAge: 150,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.FULL,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                ],
                placeReservationType: PLACE_RESERVATION_TYPE.USUAL,
                petsSegregated: false,
                beddingTariff: {currency: CurrencyType.RUB, value: 0},
                isFirm: true,
                coachSubtypeCode: '35К',
                category: {value: 'compartment', title: 'купе'},
                index: 1,
            },
            {
                adultTariff: {currency: CurrencyType.RUB, value: 1746.03},
                loyaltyCards: [TRAIN_BONUS_CARDS.BONUS_CARD],
                feeCalculationToken: 'sdfds',
                schemaId: 2,
                number: '10',
                facilities: ['COND', 'WC'],
                hasDynamicPricing: false,
                directionConfirmed: false,
                owner: 'ФПК',
                placeCounts: {
                    upperSide: 7,
                    lowerSide: 8,
                    total: 34,
                    upperCoupe: 14,
                    lowerCoupe: 5,
                },
                canChooseBedding: true,
                placesByType: null,
                trainStartNumber: '059Г',
                type: TRAIN_COACH_TYPE.PLATZKARTE,
                arrival: '2020-06-13T09:05:00+03:00',
                serviceClass: {
                    internationalCode: '',
                    code: '3Б',
                    description: 'Кондиционер,  биотуалет в вагоне.',
                    title: '',
                    key: '3Б',
                },
                twoStorey: false,
                placesByCompartment: [
                    [38],
                    [40],
                    [42],
                    [44],
                    [50],
                    [52],
                    [54],
                    [36],
                    [37],
                    [39],
                    [41],
                    [43],
                    [45],
                    [47],
                    [51],
                    [53],
                    [3],
                    [11],
                    [13],
                    [19],
                    [33],
                    [2, 4],
                    [8],
                    [10, 12],
                    [14, 16],
                    [20],
                    [24],
                    [26, 28],
                    [30, 32],
                ],
                petsAllowed: true,
                reservationVariants: null,
                electronicTicket: true,
                throughArrival: null,
                petInCoach: true,
                places: [
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 38,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 40,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 42,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 44,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 50,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 52,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 54,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 36,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.LAST_KUPE_UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 37,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 39,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 41,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 43,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 45,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 47,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 51,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 53,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 3,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 11,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 13,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 19,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 33,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 2,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 4,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 8,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 10,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 12,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 14,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 16,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 20,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 24,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 26,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 28,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 30,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 32,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                ],
                hasNonRefundableTariff: false,
                placeRequirementsAvailable: false,
                tariffsInfo: [
                    {
                        minAge: 0,
                        title: 'Детский без места',
                        minAgeIncludesBirthday: false,
                        maxAge: 5,
                        withoutPlace: true,
                        code: TrainBookedTariffCode.BABY,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 0,
                        title: 'Детский',
                        minAgeIncludesBirthday: false,
                        maxAge: 10,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 10,
                        title: 'Детский 10-18',
                        minAgeIncludesBirthday: false,
                        maxAge: 18,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD_17,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                    {
                        minAge: 0,
                        title: 'Полный',
                        minAgeIncludesBirthday: false,
                        maxAge: 150,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.FULL,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                ],
                placeReservationType: PLACE_RESERVATION_TYPE.USUAL,
                petsSegregated: false,
                beddingTariff: {currency: CurrencyType.RUB, value: 167.72},
                isFirm: true,
                coachSubtypeCode: '41П',
                category: {value: 'platzkarte', title: 'плацкарт'},
                index: 12,
            },
            {
                adultTariff: {currency: CurrencyType.RUB, value: 1746.03},
                loyaltyCards: [TRAIN_BONUS_CARDS.BONUS_CARD],
                feeCalculationToken: 'sdfds',
                schemaId: 2,
                number: '11',
                facilities: ['COND', 'WC'],
                hasDynamicPricing: false,
                directionConfirmed: false,
                owner: 'ФПК',
                placeCounts: {
                    upperSide: 9,
                    lowerSide: 9,
                    total: 33,
                    upperCoupe: 14,
                    lowerCoupe: 1,
                },
                canChooseBedding: true,
                placesByType: null,
                trainStartNumber: '059Г',
                type: TRAIN_COACH_TYPE.PLATZKARTE,
                arrival: '2020-06-13T09:05:00+03:00',
                serviceClass: {
                    internationalCode: '',
                    code: '3Э',
                    description: 'Кондиционер, биотуалет в вагоне.',
                    title: 'Эконом',
                    key: '3Э',
                },
                twoStorey: false,
                placesByCompartment: [
                    [38],
                    [40],
                    [42],
                    [44],
                    [46],
                    [48],
                    [50],
                    [52],
                    [54],
                    [37],
                    [39],
                    [41],
                    [43],
                    [45],
                    [47],
                    [49],
                    [51],
                    [53],
                    [31],
                    [2, 4],
                    [6],
                    [12],
                    [14, 16],
                    [18, 20],
                    [22, 24],
                    [26, 28],
                    [30, 32],
                ],
                petsAllowed: false,
                reservationVariants: null,
                electronicTicket: true,
                throughArrival: null,
                petInCoach: false,
                places: [
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 38,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 40,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 42,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 44,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 46,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 48,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 50,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 52,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 54,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 37,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 39,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 41,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 43,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 45,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 47,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 49,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 51,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 53,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 31,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 2,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 4,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 6,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 12,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 14,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 16,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 18,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 20,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 22,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 24,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 26,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 28,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 30,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 32,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                ],
                hasNonRefundableTariff: false,
                placeRequirementsAvailable: false,
                tariffsInfo: [
                    {
                        minAge: 0,
                        title: 'Детский без места',
                        minAgeIncludesBirthday: false,
                        maxAge: 5,
                        withoutPlace: true,
                        code: TrainBookedTariffCode.BABY,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 0,
                        title: 'Детский',
                        minAgeIncludesBirthday: false,
                        maxAge: 10,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 10,
                        title: 'Детский 10-18',
                        minAgeIncludesBirthday: false,
                        maxAge: 18,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD_17,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                    {
                        minAge: 0,
                        title: 'Полный',
                        minAgeIncludesBirthday: false,
                        maxAge: 150,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.FULL,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                ],
                placeReservationType: PLACE_RESERVATION_TYPE.USUAL,
                petsSegregated: false,
                beddingTariff: {currency: CurrencyType.RUB, value: 167.72},
                isFirm: true,
                coachSubtypeCode: '41П',
                category: {value: 'platzkarte', title: 'плацкарт'},
                index: 0,
            },
            {
                adultTariff: {currency: CurrencyType.RUB, value: 2494.17},
                loyaltyCards: [TRAIN_BONUS_CARDS.BONUS_CARD],
                feeCalculationToken: 'sdfds',
                schemaId: 2,
                number: '12',
                facilities: ['COND', 'WC'],
                hasDynamicPricing: false,
                directionConfirmed: false,
                owner: 'ФПК',
                placeCounts: {
                    upperSide: 0,
                    lowerSide: 0,
                    total: 1,
                    upperCoupe: 0,
                    lowerCoupe: 1,
                },
                canChooseBedding: true,
                placesByType: null,
                trainStartNumber: '059Г',
                type: TRAIN_COACH_TYPE.PLATZKARTE,
                arrival: '2020-06-13T09:05:00+03:00',
                serviceClass: {
                    internationalCode: '',
                    code: '3Э',
                    description: 'Кондиционер, биотуалет в вагоне.',
                    title: 'Эконом',
                    key: '3Э',
                },
                twoStorey: false,
                placesByCompartment: [[27]],
                petsAllowed: false,
                reservationVariants: null,
                electronicTicket: true,
                throughArrival: null,
                petInCoach: false,
                places: [
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 27,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                ],
                hasNonRefundableTariff: false,
                placeRequirementsAvailable: false,
                tariffsInfo: [
                    {
                        minAge: 0,
                        title: 'Детский без места',
                        minAgeIncludesBirthday: false,
                        maxAge: 5,
                        withoutPlace: true,
                        code: TrainBookedTariffCode.BABY,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 0,
                        title: 'Детский',
                        minAgeIncludesBirthday: false,
                        maxAge: 10,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 10,
                        title: 'Детский 10-18',
                        minAgeIncludesBirthday: false,
                        maxAge: 18,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD_17,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                    {
                        minAge: 0,
                        title: 'Полный',
                        minAgeIncludesBirthday: false,
                        maxAge: 150,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.FULL,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                ],
                placeReservationType: PLACE_RESERVATION_TYPE.USUAL,
                petsSegregated: false,
                beddingTariff: {currency: CurrencyType.RUB, value: 167.72},
                isFirm: true,
                coachSubtypeCode: '41П',
                category: {value: 'platzkarte', title: 'плацкарт'},
                index: 4,
            },
            {
                adultTariff: {currency: CurrencyType.RUB, value: 1746.03},
                loyaltyCards: [TRAIN_BONUS_CARDS.BONUS_CARD],
                feeCalculationToken: 'sdfds',
                schemaId: 2,
                number: '13',
                facilities: ['COND', 'WC'],
                hasDynamicPricing: false,
                directionConfirmed: false,
                owner: 'ФПК',
                placeCounts: {
                    upperSide: 8,
                    lowerSide: 9,
                    total: 42,
                    upperCoupe: 14,
                    lowerCoupe: 11,
                },
                canChooseBedding: true,
                placesByType: null,
                trainStartNumber: '059Г',
                type: TRAIN_COACH_TYPE.PLATZKARTE,
                arrival: '2020-06-13T09:05:00+03:00',
                serviceClass: {
                    internationalCode: '',
                    code: '3Э',
                    description: 'Кондиционер, биотуалет в вагоне.',
                    title: 'Эконом',
                    key: '3Э',
                },
                twoStorey: false,
                placesByCompartment: [
                    [38],
                    [40],
                    [42],
                    [44],
                    [48],
                    [50],
                    [52],
                    [54],
                    [34, 36],
                    [37],
                    [39],
                    [41],
                    [43],
                    [45],
                    [47],
                    [49],
                    [51],
                    [53],
                    [1, 3],
                    [5, 7],
                    [15],
                    [25, 27],
                    [29, 31],
                    [33, 35],
                    [2, 4],
                    [8],
                    [16],
                    [18, 20],
                    [22, 24],
                    [26, 28],
                    [30, 32],
                ],
                petsAllowed: false,
                reservationVariants: null,
                electronicTicket: true,
                throughArrival: null,
                petInCoach: false,
                places: [
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 38,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 40,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 42,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 44,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 48,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 50,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 52,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 54,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 34,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.LAST_KUPE_UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1746.03,
                        },
                        gender: null,
                        number: 36,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 615.28,
                        },
                        type: TrainPlaceType.LAST_KUPE_UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 37,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 39,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 41,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 43,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 45,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 47,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 49,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 51,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 53,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 1,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 3,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 5,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 7,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 15,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 25,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 27,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 29,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 31,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 33,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 35,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 2,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 4,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 8,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 16,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 18,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 20,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 22,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 24,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 26,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 28,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 30,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2494.17,
                        },
                        gender: null,
                        number: 32,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 872.96,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                ],
                hasNonRefundableTariff: false,
                placeRequirementsAvailable: false,
                tariffsInfo: [
                    {
                        minAge: 0,
                        title: 'Детский без места',
                        minAgeIncludesBirthday: false,
                        maxAge: 5,
                        withoutPlace: true,
                        code: TrainBookedTariffCode.BABY,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 0,
                        title: 'Детский',
                        minAgeIncludesBirthday: false,
                        maxAge: 10,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 10,
                        title: 'Детский 10-18',
                        minAgeIncludesBirthday: false,
                        maxAge: 18,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD_17,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                    {
                        minAge: 0,
                        title: 'Полный',
                        minAgeIncludesBirthday: false,
                        maxAge: 150,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.FULL,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                ],
                placeReservationType: PLACE_RESERVATION_TYPE.USUAL,
                petsSegregated: false,
                beddingTariff: {currency: CurrencyType.RUB, value: 167.72},
                isFirm: true,
                coachSubtypeCode: '41П',
                category: {value: 'platzkarte', title: 'плацкарт'},
                index: 5,
            },
            {
                adultTariff: {currency: CurrencyType.RUB, value: 1164.06},
                loyaltyCards: [TRAIN_BONUS_CARDS.BONUS_CARD],
                feeCalculationToken: 'sdfds',
                schemaId: 2,
                number: '20',
                facilities: ['COND', 'WC'],
                hasDynamicPricing: false,
                directionConfirmed: false,
                owner: 'ФПК',
                placeCounts: {
                    upperSide: 4,
                    lowerSide: 7,
                    total: 38,
                    upperCoupe: 16,
                    lowerCoupe: 11,
                },
                canChooseBedding: true,
                placesByType: null,
                trainStartNumber: '059Г',
                type: TRAIN_COACH_TYPE.PLATZKARTE,
                arrival: '2020-06-13T09:05:00+03:00',
                serviceClass: {
                    internationalCode: '',
                    code: '3Э',
                    description: 'Кондиционер, биотуалет в вагоне.',
                    title: 'Эконом',
                    key: '3Э',
                },
                twoStorey: false,
                placesByCompartment: [
                    [38],
                    [40],
                    [42],
                    [54],
                    [36],
                    [37],
                    [39],
                    [41],
                    [43],
                    [47],
                    [49],
                    [53],
                    [1, 3],
                    [5],
                    [9, 11],
                    [23],
                    [27],
                    [29, 31],
                    [33, 35],
                    [2, 4],
                    [8],
                    [10, 12],
                    [14, 16],
                    [18, 20],
                    [22, 24],
                    [26, 28],
                    [30, 32],
                ],
                petsAllowed: false,
                reservationVariants: null,
                electronicTicket: true,
                throughArrival: null,
                petInCoach: false,
                places: [
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1164.06,
                        },
                        gender: null,
                        number: 38,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 420.77,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1164.06,
                        },
                        gender: null,
                        number: 40,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 420.77,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1164.06,
                        },
                        gender: null,
                        number: 42,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 420.77,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1164.06,
                        },
                        gender: null,
                        number: 54,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 420.77,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1164.06,
                        },
                        gender: null,
                        number: 36,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 420.77,
                        },
                        type: TrainPlaceType.LAST_KUPE_UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 37,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 39,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 41,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 43,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 47,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 49,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 53,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 1,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 3,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 5,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 9,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 11,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 23,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 27,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 29,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 31,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 33,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 35,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 2,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 4,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 8,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 10,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 12,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 14,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 16,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 18,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 20,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 22,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 24,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 26,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 28,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 30,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 32,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                ],
                hasNonRefundableTariff: false,
                placeRequirementsAvailable: false,
                tariffsInfo: [
                    {
                        minAge: 0,
                        title: 'Детский без места',
                        minAgeIncludesBirthday: false,
                        maxAge: 5,
                        withoutPlace: true,
                        code: TrainBookedTariffCode.BABY,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 0,
                        title: 'Детский',
                        minAgeIncludesBirthday: false,
                        maxAge: 10,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 10,
                        title: 'Детский 10-18',
                        minAgeIncludesBirthday: false,
                        maxAge: 18,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD_17,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                    {
                        minAge: 0,
                        title: 'Полный',
                        minAgeIncludesBirthday: false,
                        maxAge: 150,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.FULL,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                ],
                placeReservationType: PLACE_RESERVATION_TYPE.USUAL,
                petsSegregated: false,
                beddingTariff: {currency: CurrencyType.RUB, value: 167.72},
                isFirm: false,
                coachSubtypeCode: '41П',
                category: {value: 'platzkarte', title: 'плацкарт'},
                index: 8,
            },
            {
                adultTariff: {currency: CurrencyType.RUB, value: 1164.06},
                loyaltyCards: [TRAIN_BONUS_CARDS.BONUS_CARD],
                feeCalculationToken: 'sdfds',
                schemaId: 2,
                number: '21',
                facilities: ['COND', 'WC'],
                hasDynamicPricing: false,
                directionConfirmed: false,
                owner: 'ФПК',
                placeCounts: {
                    upperSide: 1,
                    lowerSide: 3,
                    total: 15,
                    upperCoupe: 11,
                    lowerCoupe: 0,
                },
                canChooseBedding: true,
                placesByType: null,
                trainStartNumber: '059Г',
                type: TRAIN_COACH_TYPE.PLATZKARTE,
                arrival: '2020-06-13T09:05:00+03:00',
                serviceClass: {
                    internationalCode: '',
                    code: '3Э',
                    description: 'Кондиционер, биотуалет в вагоне.',
                    title: 'Эконом',
                    key: '3Э',
                },
                twoStorey: false,
                placesByCompartment: [
                    [48],
                    [39],
                    [43],
                    [49],
                    [2, 4],
                    [6, 8],
                    [12],
                    [14, 16],
                    [20],
                    [24],
                    [26, 28],
                ],
                petsAllowed: false,
                reservationVariants: null,
                electronicTicket: true,
                throughArrival: null,
                petInCoach: false,
                places: [
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1164.06,
                        },
                        gender: null,
                        number: 48,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 420.77,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 39,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 43,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 49,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 2,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 4,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 6,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 8,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 12,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 14,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 16,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 20,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 24,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 26,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 28,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                ],
                hasNonRefundableTariff: false,
                placeRequirementsAvailable: false,
                tariffsInfo: [
                    {
                        minAge: 0,
                        title: 'Детский без места',
                        minAgeIncludesBirthday: false,
                        maxAge: 5,
                        withoutPlace: true,
                        code: TrainBookedTariffCode.BABY,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 0,
                        title: 'Детский',
                        minAgeIncludesBirthday: false,
                        maxAge: 10,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 10,
                        title: 'Детский 10-18',
                        minAgeIncludesBirthday: false,
                        maxAge: 18,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD_17,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                    {
                        minAge: 0,
                        title: 'Полный',
                        minAgeIncludesBirthday: false,
                        maxAge: 150,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.FULL,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                ],
                placeReservationType: PLACE_RESERVATION_TYPE.USUAL,
                petsSegregated: false,
                beddingTariff: {currency: CurrencyType.RUB, value: 167.72},
                isFirm: false,
                coachSubtypeCode: '41П',
                category: {value: 'platzkarte', title: 'плацкарт'},
                index: 3,
            },
            {
                adultTariff: {currency: CurrencyType.RUB, value: 1164.06},
                loyaltyCards: [TRAIN_BONUS_CARDS.BONUS_CARD],
                feeCalculationToken: 'sdfds',
                schemaId: 2,
                number: '22',
                facilities: ['COND', 'WC'],
                hasDynamicPricing: false,
                directionConfirmed: false,
                owner: 'ФПК',
                placeCounts: {
                    upperSide: 1,
                    lowerSide: 4,
                    total: 21,
                    upperCoupe: 13,
                    lowerCoupe: 3,
                },
                canChooseBedding: true,
                placesByType: null,
                trainStartNumber: '059Г',
                type: TRAIN_COACH_TYPE.PLATZKARTE,
                arrival: '2020-06-13T09:05:00+03:00',
                serviceClass: {
                    internationalCode: '',
                    code: '3Э',
                    description: 'Кондиционер, биотуалет в вагоне.',
                    title: 'Эконом',
                    key: '3Э',
                },
                twoStorey: false,
                placesByCompartment: [
                    [34],
                    [38],
                    [37],
                    [39],
                    [41],
                    [47],
                    [11],
                    [13, 15],
                    [2, 4],
                    [6, 8],
                    [10, 12],
                    [14, 16],
                    [24],
                    [28],
                    [30, 32],
                ],
                petsAllowed: false,
                reservationVariants: null,
                electronicTicket: true,
                throughArrival: null,
                petInCoach: false,
                places: [
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1164.06,
                        },
                        gender: null,
                        number: 34,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 420.77,
                        },
                        type: TrainPlaceType.LAST_KUPE_UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1164.06,
                        },
                        gender: null,
                        number: 38,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 420.77,
                        },
                        type: TrainPlaceType.SIDE_UPPER_NEAR_RESTROOM,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 37,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 39,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 41,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 47,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 11,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 13,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 15,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 2,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 4,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 6,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 8,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 10,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 12,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 14,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 16,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 24,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 28,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 30,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 32,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                ],
                hasNonRefundableTariff: false,
                placeRequirementsAvailable: false,
                tariffsInfo: [
                    {
                        minAge: 0,
                        title: 'Детский без места',
                        minAgeIncludesBirthday: false,
                        maxAge: 5,
                        withoutPlace: true,
                        code: TrainBookedTariffCode.BABY,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 0,
                        title: 'Детский',
                        minAgeIncludesBirthday: false,
                        maxAge: 10,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 10,
                        title: 'Детский 10-18',
                        minAgeIncludesBirthday: false,
                        maxAge: 18,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD_17,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                    {
                        minAge: 0,
                        title: 'Полный',
                        minAgeIncludesBirthday: false,
                        maxAge: 150,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.FULL,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                ],
                placeReservationType: PLACE_RESERVATION_TYPE.USUAL,
                petsSegregated: false,
                beddingTariff: {currency: CurrencyType.RUB, value: 167.72},
                isFirm: false,
                coachSubtypeCode: '41П',
                category: {value: 'platzkarte', title: 'плацкарт'},
                index: 9,
            },
            {
                adultTariff: {currency: CurrencyType.RUB, value: 1164.06},
                loyaltyCards: [TRAIN_BONUS_CARDS.BONUS_CARD],
                feeCalculationToken: 'sdfds',
                schemaId: 2,
                number: '23',
                facilities: ['COND', 'WC'],
                hasDynamicPricing: false,
                directionConfirmed: false,
                owner: 'ФПК',
                placeCounts: {
                    upperSide: 4,
                    lowerSide: 3,
                    total: 20,
                    upperCoupe: 13,
                    lowerCoupe: 0,
                },
                canChooseBedding: true,
                placesByType: null,
                trainStartNumber: '059Г',
                type: TRAIN_COACH_TYPE.PLATZKARTE,
                arrival: '2020-06-13T09:05:00+03:00',
                serviceClass: {
                    internationalCode: '',
                    code: '3Э',
                    description: 'Кондиционер, биотуалет в вагоне.',
                    title: 'Эконом',
                    key: '3Э',
                },
                twoStorey: false,
                placesByCompartment: [
                    [38],
                    [40],
                    [42],
                    [44],
                    [34, 36],
                    [37],
                    [41],
                    [43],
                    [4],
                    [6],
                    [12],
                    [16],
                    [18, 20],
                    [22, 24],
                    [26, 28],
                    [30],
                ],
                petsAllowed: false,
                reservationVariants: null,
                electronicTicket: true,
                throughArrival: null,
                petInCoach: false,
                places: [
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1164.06,
                        },
                        gender: null,
                        number: 38,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 420.77,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1164.06,
                        },
                        gender: null,
                        number: 40,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 420.77,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1164.06,
                        },
                        gender: null,
                        number: 42,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 420.77,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1164.06,
                        },
                        gender: null,
                        number: 44,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 420.77,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1164.06,
                        },
                        gender: null,
                        number: 34,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 420.77,
                        },
                        type: TrainPlaceType.LAST_KUPE_UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1164.06,
                        },
                        gender: null,
                        number: 36,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 420.77,
                        },
                        type: TrainPlaceType.LAST_KUPE_UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 37,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 41,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 43,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.SIDE_LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 4,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 6,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 12,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 16,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 18,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 20,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 22,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 24,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 26,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 28,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 30,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                ],
                hasNonRefundableTariff: false,
                placeRequirementsAvailable: false,
                tariffsInfo: [
                    {
                        minAge: 0,
                        title: 'Детский без места',
                        minAgeIncludesBirthday: false,
                        maxAge: 5,
                        withoutPlace: true,
                        code: TrainBookedTariffCode.BABY,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 0,
                        title: 'Детский',
                        minAgeIncludesBirthday: false,
                        maxAge: 10,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 10,
                        title: 'Детский 10-18',
                        minAgeIncludesBirthday: false,
                        maxAge: 18,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD_17,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                    {
                        minAge: 0,
                        title: 'Полный',
                        minAgeIncludesBirthday: false,
                        maxAge: 150,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.FULL,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                ],
                placeReservationType: PLACE_RESERVATION_TYPE.USUAL,
                petsSegregated: false,
                beddingTariff: {currency: CurrencyType.RUB, value: 167.72},
                isFirm: false,
                coachSubtypeCode: '41П',
                category: {value: 'platzkarte', title: 'плацкарт'},
                index: 2,
            },
            {
                adultTariff: {currency: CurrencyType.RUB, value: 1164.06},
                loyaltyCards: [TRAIN_BONUS_CARDS.BONUS_CARD],
                feeCalculationToken: 'sdfds',
                schemaId: 2,
                number: '24',
                facilities: ['COND', 'WC'],
                hasDynamicPricing: false,
                directionConfirmed: false,
                owner: 'ФПК',
                placeCounts: {
                    upperSide: 1,
                    lowerSide: 0,
                    total: 3,
                    upperCoupe: 2,
                    lowerCoupe: 0,
                },
                canChooseBedding: true,
                placesByType: null,
                trainStartNumber: '059Г',
                type: TRAIN_COACH_TYPE.PLATZKARTE,
                arrival: '2020-06-13T09:05:00+03:00',
                serviceClass: {
                    internationalCode: '',
                    code: '3Б',
                    description: 'Кондиционер,  биотуалет в вагоне.',
                    title: '',
                    key: '3Б',
                },
                twoStorey: false,
                placesByCompartment: [[38], [28], [30]],
                petsAllowed: true,
                reservationVariants: null,
                electronicTicket: true,
                throughArrival: null,
                petInCoach: true,
                places: [
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1164.06,
                        },
                        gender: null,
                        number: 38,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 420.77,
                        },
                        type: TrainPlaceType.SIDE_UPPER_NEAR_RESTROOM,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 28,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 1662.78,
                        },
                        gender: null,
                        number: 30,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 167.72,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 587.46,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                ],
                hasNonRefundableTariff: false,
                placeRequirementsAvailable: false,
                tariffsInfo: [
                    {
                        minAge: 0,
                        title: 'Детский без места',
                        minAgeIncludesBirthday: false,
                        maxAge: 5,
                        withoutPlace: true,
                        code: TrainBookedTariffCode.BABY,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 0,
                        title: 'Детский',
                        minAgeIncludesBirthday: false,
                        maxAge: 10,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 10,
                        title: 'Детский 10-18',
                        minAgeIncludesBirthday: false,
                        maxAge: 18,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD_17,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                    {
                        minAge: 0,
                        title: 'Полный',
                        minAgeIncludesBirthday: false,
                        maxAge: 150,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.FULL,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                ],
                placeReservationType: PLACE_RESERVATION_TYPE.USUAL,
                petsSegregated: false,
                beddingTariff: {currency: CurrencyType.RUB, value: 167.72},
                isFirm: false,
                coachSubtypeCode: '41П',
                category: {value: 'platzkarte', title: 'плацкарт'},
                index: 13,
            },
            {
                adultTariff: {currency: CurrencyType.RUB, value: 2600.51},
                loyaltyCards: [TRAIN_BONUS_CARDS.BONUS_CARD],
                feeCalculationToken: 'sdfds',
                schemaId: 3,
                number: '25',
                facilities: ['COND', 'WC', 'PETS'],
                hasDynamicPricing: true,
                directionConfirmed: false,
                owner: 'ФПК',
                placeCounts: {
                    upperSide: 0,
                    lowerSide: 0,
                    total: 11,
                    upperCoupe: 6,
                    lowerCoupe: 5,
                },
                canChooseBedding: false,
                placesByType: null,
                trainStartNumber: '059Г',
                type: TRAIN_COACH_TYPE.COMPARTMENT,
                arrival: '2020-06-13T09:05:00+03:00',
                serviceClass: {
                    internationalCode: '',
                    code: '2К',
                    description:
                        'Кондиционер, биотуалет в вагоне. В стоимость проезда входит бельё. Разрешено перевозить животных.',
                    title: 'Эконом',
                    key: '2К',
                },
                twoStorey: false,
                placesByCompartment: [
                    [6, 8],
                    [10, 12],
                    [16],
                    [18],
                    [5],
                    [9, 11],
                    [15],
                    [17],
                ],
                petsAllowed: true,
                reservationVariants: null,
                electronicTicket: true,
                throughArrival: null,
                petInCoach: true,
                places: [
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: null,
                        number: 6,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: null,
                        number: 8,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: null,
                        number: 10,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: null,
                        number: 12,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: null,
                        number: 16,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: null,
                        number: 18,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: null,
                        number: 5,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: null,
                        number: 9,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: null,
                        number: 11,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: null,
                        number: 15,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: null,
                        number: 17,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                ],
                tariffsInfo: [
                    {
                        minAge: 0,
                        title: 'Детский без места',
                        minAgeIncludesBirthday: false,
                        maxAge: 5,
                        withoutPlace: true,
                        code: TrainBookedTariffCode.BABY,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 0,
                        title: 'Детский',
                        minAgeIncludesBirthday: false,
                        maxAge: 10,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 10,
                        title: 'Детский 10-18',
                        minAgeIncludesBirthday: false,
                        maxAge: 18,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD_17,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                    {
                        minAge: 0,
                        title: 'Полный',
                        minAgeIncludesBirthday: false,
                        maxAge: 150,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.FULL,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                ],
                placeReservationType: PLACE_RESERVATION_TYPE.USUAL,
                petsSegregated: false,
                beddingTariff: {currency: CurrencyType.RUB, value: 0},
                isFirm: false,
                coachSubtypeCode: '35К',
                category: {value: 'compartment', title: 'купе'},
                index: 7,
                hasNonRefundableTariff: false,
                placeRequirementsAvailable: false,
            },
            {
                adultTariff: {currency: CurrencyType.RUB, value: 2600.51},
                loyaltyCards: [TRAIN_BONUS_CARDS.BONUS_CARD],
                feeCalculationToken: 'sdfds',
                schemaId: 3,
                number: '26',
                facilities: ['COND', 'WC', 'PETS'],
                hasDynamicPricing: true,
                directionConfirmed: false,
                owner: 'ФПК',
                placeCounts: {
                    upperSide: 0,
                    lowerSide: 0,
                    total: 17,
                    upperCoupe: 8,
                    lowerCoupe: 9,
                },
                canChooseBedding: false,
                placesByType: null,
                trainStartNumber: '059Г',
                type: TRAIN_COACH_TYPE.COMPARTMENT,
                arrival: '2020-06-13T09:05:00+03:00',
                serviceClass: {
                    internationalCode: '',
                    code: '2К',
                    description:
                        'Кондиционер, биотуалет в вагоне. В стоимость проезда входит бельё. Разрешено перевозить животных.',
                    title: 'Эконом',
                    key: '2К',
                },
                twoStorey: false,
                placesByCompartment: [
                    [2, 4],
                    [6],
                    [12],
                    [14, 16],
                    [32],
                    [36],
                    [5, 7],
                    [15],
                    [19],
                    [21, 23],
                    [27],
                    [33, 35],
                ],
                petsAllowed: true,
                reservationVariants: null,
                electronicTicket: true,
                throughArrival: null,
                petInCoach: true,
                places: [
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 2,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 4,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 6,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 12,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 14,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 16,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 32,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 36,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 5,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 7,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 15,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 19,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: GENDER_TYPE.MALE,
                        number: 21,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: GENDER_TYPE.MALE,
                        number: 23,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: GENDER_TYPE.MIXED,
                        number: 27,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 33,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: GENDER_TYPE.FEMALE,
                        number: 35,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                ],
                hasNonRefundableTariff: false,
                placeRequirementsAvailable: false,
                tariffsInfo: [
                    {
                        minAge: 0,
                        title: 'Детский без места',
                        minAgeIncludesBirthday: false,
                        maxAge: 5,
                        withoutPlace: true,
                        code: TrainBookedTariffCode.BABY,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 0,
                        title: 'Детский',
                        minAgeIncludesBirthday: false,
                        maxAge: 10,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 10,
                        title: 'Детский 10-18',
                        minAgeIncludesBirthday: false,
                        maxAge: 18,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD_17,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                    {
                        minAge: 0,
                        title: 'Полный',
                        minAgeIncludesBirthday: false,
                        maxAge: 150,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.FULL,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                ],
                placeReservationType: PLACE_RESERVATION_TYPE.USUAL,
                petsSegregated: false,
                beddingTariff: {currency: CurrencyType.RUB, value: 0},
                isFirm: false,
                coachSubtypeCode: '66К',
                category: {value: 'compartment', title: 'купе'},
                index: 6,
            },
            {
                adultTariff: {currency: CurrencyType.RUB, value: 2600.51},
                loyaltyCards: [TRAIN_BONUS_CARDS.BONUS_CARD],
                feeCalculationToken: 'sdfds',
                schemaId: 3,
                number: '27',
                facilities: ['COND', 'WC', 'PETS'],
                hasDynamicPricing: true,
                directionConfirmed: false,
                owner: 'ФПК',
                placeCounts: {
                    upperSide: 0,
                    lowerSide: 0,
                    total: 21,
                    upperCoupe: 11,
                    lowerCoupe: 10,
                },
                canChooseBedding: false,
                placesByType: null,
                trainStartNumber: '059Г',
                type: TRAIN_COACH_TYPE.COMPARTMENT,
                arrival: '2020-06-13T09:05:00+03:00',
                serviceClass: {
                    internationalCode: '',
                    code: '2К',
                    description:
                        'Кондиционер, биотуалет в вагоне. В стоимость проезда входит бельё. Разрешено перевозить животных.',
                    title: 'Эконом',
                    key: '2К',
                },
                twoStorey: false,
                placesByCompartment: [
                    [2, 4],
                    [10],
                    [14, 16],
                    [22],
                    [26],
                    [30, 32],
                    [34, 36],
                    [1, 3],
                    [5, 7],
                    [9],
                    [19],
                    [23],
                    [27],
                    [29, 31],
                ],
                petsAllowed: true,
                reservationVariants: null,
                electronicTicket: true,
                throughArrival: null,
                petInCoach: true,
                places: [
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: null,
                        number: 2,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: null,
                        number: 4,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: null,
                        number: 10,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: null,
                        number: 14,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: null,
                        number: 16,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: null,
                        number: 22,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: null,
                        number: 26,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: null,
                        number: 30,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: null,
                        number: 32,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: null,
                        number: 34,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 2600.51,
                        },
                        gender: null,
                        number: 36,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1026.34,
                        },
                        type: TrainPlaceType.UPPER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: null,
                        number: 1,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: null,
                        number: 3,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: null,
                        number: 5,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: null,
                        number: 7,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: null,
                        number: 9,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: null,
                        number: 19,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: null,
                        number: 23,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: null,
                        number: 27,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: null,
                        number: 29,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                    {
                        adultTariff: {
                            currency: CurrencyType.RUB,
                            value: 3589.74,
                        },
                        gender: null,
                        number: 31,
                        beddingTariffWithFee: {
                            currency: CurrencyType.RUB,
                            value: 0,
                        },
                        childTariff: {
                            currency: CurrencyType.RUB,
                            value: 1372.57,
                        },
                        type: TrainPlaceType.LOWER,
                        adultNonRefundableTariff: null,
                        childNonRefundableTariff: null,
                    },
                ],
                tariffsInfo: [
                    {
                        minAge: 0,
                        title: 'Детский без места',
                        minAgeIncludesBirthday: false,
                        maxAge: 5,
                        withoutPlace: true,
                        code: TrainBookedTariffCode.BABY,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 0,
                        title: 'Детский',
                        minAgeIncludesBirthday: false,
                        maxAge: 10,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD,
                        needDocument: false,
                        maxAgeIncludesBirthday: true,
                    },
                    {
                        minAge: 10,
                        title: 'Детский 10-18',
                        minAgeIncludesBirthday: false,
                        maxAge: 18,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.CHILD_17,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                    {
                        minAge: 0,
                        title: 'Полный',
                        minAgeIncludesBirthday: false,
                        maxAge: 150,
                        withoutPlace: false,
                        code: TrainBookedTariffCode.FULL,
                        needDocument: false,
                        maxAgeIncludesBirthday: false,
                    },
                ],
                placeReservationType: PLACE_RESERVATION_TYPE.USUAL,
                petsSegregated: false,
                beddingTariff: {currency: CurrencyType.RUB, value: 0},
                isFirm: false,
                coachSubtypeCode: '66К',
                category: {value: TRAIN_COACH_TYPE.COMPARTMENT, title: 'купе'},
                index: 14,
                hasNonRefundableTariff: false,
                placeRequirementsAvailable: false,
            },
        ],
        startNumber: '059Г',
        routePolicy: ERoutePolicy.INTERNAL,
        stationFrom: {expressCode: '2000001', id: 2000001},
        isCppk: false,
        tariffCategories: [
            {
                minAge: 0,
                minAgeIncludesBirthday: false,
                maxAge: 5,
                withoutPlace: true,
                code: TrainsTariffCategoryCode.BABY,
                needDocument: false,
                maxAgeIncludesBirthday: true,
            },
            {
                minAge: 5,
                minAgeIncludesBirthday: false,
                maxAge: 10,
                withoutPlace: false,
                code: TrainsTariffCategoryCode.CHILD,
                needDocument: false,
                maxAgeIncludesBirthday: true,
            },
            {
                minAge: 10,
                minAgeIncludesBirthday: false,
                maxAge: 150,
                withoutPlace: false,
                code: TrainsTariffCategoryCode.FULL,
                needDocument: false,
                maxAgeIncludesBirthday: false,
            },
        ],
        imInitialStationName: 'Н.НОВГОРОД М',
        stationTo: {expressCode: '2004001', id: 9602494},
        schemas: {
            '2': {
                hidePlaceNumbers: false,
                places: [
                    {geometry: {top: 22, left: 140}, groupNumber: 1, number: 1},
                    {geometry: {top: 0, left: 140}, groupNumber: 1, number: 2},
                    {geometry: {top: 22, left: 163}, groupNumber: 1, number: 3},
                    {geometry: {top: 0, left: 163}, groupNumber: 1, number: 4},
                    {geometry: {top: 22, left: 193}, groupNumber: 2, number: 5},
                    {geometry: {top: 0, left: 193}, groupNumber: 2, number: 6},
                    {geometry: {top: 22, left: 216}, groupNumber: 2, number: 7},
                    {geometry: {top: 0, left: 216}, groupNumber: 2, number: 8},
                    {geometry: {top: 22, left: 246}, groupNumber: 3, number: 9},
                    {geometry: {top: 0, left: 246}, groupNumber: 3, number: 10},
                    {
                        geometry: {top: 22, left: 269},
                        groupNumber: 3,
                        number: 11,
                    },
                    {geometry: {top: 0, left: 269}, groupNumber: 3, number: 12},
                    {
                        geometry: {top: 22, left: 299},
                        groupNumber: 4,
                        number: 13,
                    },
                    {geometry: {top: 0, left: 299}, groupNumber: 4, number: 14},
                    {
                        geometry: {top: 22, left: 322},
                        groupNumber: 4,
                        number: 15,
                    },
                    {geometry: {top: 0, left: 322}, groupNumber: 4, number: 16},
                    {
                        geometry: {top: 22, left: 352},
                        groupNumber: 5,
                        number: 17,
                    },
                    {geometry: {top: 0, left: 352}, groupNumber: 5, number: 18},
                    {
                        geometry: {top: 22, left: 375},
                        groupNumber: 5,
                        number: 19,
                    },
                    {geometry: {top: 0, left: 375}, groupNumber: 5, number: 20},
                    {
                        geometry: {top: 22, left: 405},
                        groupNumber: 6,
                        number: 21,
                    },
                    {geometry: {top: 0, left: 405}, groupNumber: 6, number: 22},
                    {
                        geometry: {top: 22, left: 428},
                        groupNumber: 6,
                        number: 23,
                    },
                    {geometry: {top: 0, left: 428}, groupNumber: 6, number: 24},
                    {
                        geometry: {top: 22, left: 458},
                        groupNumber: 7,
                        number: 25,
                    },
                    {geometry: {top: 0, left: 458}, groupNumber: 7, number: 26},
                    {
                        geometry: {top: 22, left: 481},
                        groupNumber: 7,
                        number: 27,
                    },
                    {geometry: {top: 0, left: 481}, groupNumber: 7, number: 28},
                    {
                        geometry: {top: 22, left: 511},
                        groupNumber: 8,
                        number: 29,
                    },
                    {geometry: {top: 0, left: 511}, groupNumber: 8, number: 30},
                    {
                        geometry: {top: 22, left: 534},
                        groupNumber: 8,
                        number: 31,
                    },
                    {geometry: {top: 0, left: 534}, groupNumber: 8, number: 32},
                    {
                        geometry: {top: 22, left: 564},
                        groupNumber: 9,
                        number: 33,
                    },
                    {geometry: {top: 0, left: 564}, groupNumber: 9, number: 34},
                    {
                        geometry: {top: 22, left: 587},
                        groupNumber: 9,
                        number: 35,
                    },
                    {geometry: {top: 0, left: 587}, groupNumber: 9, number: 36},
                    {
                        geometry: {top: 149, left: 152},
                        groupNumber: 18,
                        number: 53,
                    },
                    {
                        geometry: {top: 128, left: 152},
                        groupNumber: 18,
                        number: 54,
                    },
                    {
                        geometry: {top: 149, left: 205},
                        groupNumber: 17,
                        number: 51,
                    },
                    {
                        geometry: {top: 128, left: 205},
                        groupNumber: 17,
                        number: 52,
                    },
                    {
                        geometry: {top: 149, left: 258},
                        groupNumber: 16,
                        number: 49,
                    },
                    {
                        geometry: {top: 128, left: 258},
                        groupNumber: 16,
                        number: 50,
                    },
                    {
                        geometry: {top: 149, left: 311},
                        groupNumber: 15,
                        number: 47,
                    },
                    {
                        geometry: {top: 128, left: 311},
                        groupNumber: 15,
                        number: 48,
                    },
                    {
                        geometry: {top: 149, left: 364},
                        groupNumber: 14,
                        number: 45,
                    },
                    {
                        geometry: {top: 128, left: 364},
                        groupNumber: 14,
                        number: 46,
                    },
                    {
                        geometry: {top: 149, left: 417},
                        groupNumber: 13,
                        number: 43,
                    },
                    {
                        geometry: {top: 128, left: 417},
                        groupNumber: 13,
                        number: 44,
                    },
                    {
                        geometry: {top: 149, left: 470},
                        groupNumber: 12,
                        number: 41,
                    },
                    {
                        geometry: {top: 128, left: 470},
                        groupNumber: 12,
                        number: 42,
                    },
                    {
                        geometry: {top: 149, left: 523},
                        groupNumber: 11,
                        number: 39,
                    },
                    {
                        geometry: {top: 128, left: 523},
                        groupNumber: 11,
                        number: 40,
                    },
                    {
                        geometry: {top: 149, left: 576},
                        groupNumber: 10,
                        number: 37,
                    },
                    {
                        geometry: {top: 128, left: 576},
                        groupNumber: 10,
                        number: 38,
                    },
                ],
                url: '//yastatic.net/s3/rasp/media/data/coachinfo/image/platzkarten2_7.png',
                svg: '<svg width="756" height="172" viewBox="0 0 756 172" fill="none" xmlns="http://www.w3.org/2000/svg">\r\n<rect width="756" height="172" fill="#F2F2F2"/>\r\n<g id="&#208;&#159;&#208;&#187;&#208;&#176;&#209;&#134;&#208;&#186;&#208;&#176;&#209;&#128;&#209;&#130;, 54 &#208;&#188;&#208;&#181;&#209;&#129;&#209;&#130;&#208;&#176;">\r\n<rect width="756" height="172" fill="white"/>\r\n<g id="scheme">\r\n<g id="base">\r\n<rect id="base_2" x="1" y="5" width="754" height="162" rx="7" fill="white" stroke="#CFCFCF" stroke-width="2"/>\r\n<text id="&#208;&#177;&#208;&#190;&#208;&#186;&#208;&#190;&#208;&#178;&#209;&#139;&#208;&#181; &#208;&#178;&#208;&#181;&#209;&#128;&#209;&#133;&#208;&#189;&#208;&#184;&#208;&#181;" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="12" letter-spacing="0px"><tspan x="18" y="117.136">&#x431;&#x43e;&#x43a;&#x43e;&#x432;&#x44b;&#x435; &#x432;&#x435;&#x440;&#x445;&#x43d;&#x438;&#x435;</tspan></text>\r\n<text id="&#208;&#177;&#208;&#190;&#208;&#186;&#208;&#190;&#208;&#178;&#209;&#139;&#208;&#181; &#208;&#189;&#208;&#184;&#208;&#182;&#208;&#189;&#208;&#184;&#208;&#181;" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="12" letter-spacing="0px"><tspan x="18" y="143.136">&#x431;&#x43e;&#x43a;&#x43e;&#x432;&#x44b;&#x435; &#x43d;&#x438;&#x436;&#x43d;&#x438;&#x435;</tspan></text>\r\n<text id="&#208;&#178;&#208;&#181;&#209;&#128;&#209;&#133;&#208;&#189;&#208;&#184;&#208;&#181;" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="12" letter-spacing="0px"><tspan x="18" y="39.136">&#x432;&#x435;&#x440;&#x445;&#x43d;&#x438;&#x435;</tspan></text>\r\n<text id="&#208;&#189;&#208;&#184;&#208;&#182;&#208;&#189;&#208;&#184;&#208;&#181;" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="12" letter-spacing="0px"><tspan x="18" y="65.136">&#x43d;&#x438;&#x436;&#x43d;&#x438;&#x435;</tspan></text>\r\n<g id="enters/enter-bottom">\r\n<rect id="Path" x="18" y="156" width="20" height="12" fill="white"/>\r\n<path id="Combined Shape" fill-rule="evenodd" clip-rule="evenodd" d="M38 168H36V158H20V168H18V156H38V168ZM24 168L28 162L32 168H29V172H27V168H24Z" fill="#CFCFCF"/>\r\n</g>\r\n<g id="enters/enter-top">\r\n<rect id="Path_2" x="18" y="4" width="20" height="12" fill="white"/>\r\n<path id="Combined Shape_2" fill-rule="evenodd" clip-rule="evenodd" d="M29 4V0H27V4H24L28 10L32 4H29ZM36 4V14H20V4H18V16H38V4H36Z" fill="#CFCFCF"/>\r\n</g>\r\n</g>\r\n<g id="warp">\r\n<g id="warp/warp-58-58">\r\n<rect id="warp-58-58" x="156" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-58-58_2">\r\n<rect id="warp-58-58_2" x="222" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-58-58_3">\r\n<rect id="warp-58-58_3" x="288" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-58-58_4">\r\n<rect id="warp-58-58_4" x="354" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-58-58_5">\r\n<rect id="warp-58-58_5" x="420" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-58-58_6">\r\n<rect id="warp-58-58_6" x="486" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-58-58_7">\r\n<rect id="warp-58-58_7" x="552" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-58-58_8">\r\n<rect id="warp-58-58_8" x="618" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-58-58_9">\r\n<rect id="warp-58-58_9" x="684" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-32-58">\r\n<rect id="warp-32-58" x="182" y="96" width="32" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-32-58_2">\r\n<rect id="warp-32-58_2" x="248" y="96" width="32" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-32-58_3">\r\n<rect id="warp-32-58_3" x="314" y="96" width="32" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-32-58_4">\r\n<rect id="warp-32-58_4" x="380" y="96" width="32" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-32-58_5">\r\n<rect id="warp-32-58_5" x="446" y="96" width="32" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-32-58_6">\r\n<rect id="warp-32-58_6" x="512" y="96" width="32" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-32-58_7">\r\n<rect id="warp-32-58_7" x="578" y="96" width="32" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-32-58_8">\r\n<rect id="warp-32-58_8" x="644" y="96" width="32" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-32-58_9">\r\n<rect id="warp-32-58_9" x="710" y="96" width="32" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n</g>\r\n<g id="places">\r\n<g id="tier/place-54">\r\n<g id="place">\r\n<path id="oval" fill-rule="evenodd" clip-rule="evenodd" d="M198 114C199.105 114 200 113.105 200 112C200 110.895 199.105 110 198 110C196.895 110 196 110.895 196 112C196 113.105 196.895 114 198 114Z" fill="#9C9C9C"/>\r\n<rect id="place_2" x="186.5" y="100.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger" x="186" y="100" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="54" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="189.753" y="117.13">54</tspan></text>\r\n</g>\r\n<g id="tier/place-53">\r\n<g id="place_3">\r\n<path id="oval_2" fill-rule="evenodd" clip-rule="evenodd" d="M198 140C199.105 140 200 139.105 200 138C200 136.895 199.105 136 198 136C196.895 136 196 136.895 196 138C196 139.105 196.895 140 198 140Z" fill="#9C9C9C"/>\r\n<rect id="place_4" x="186.5" y="126.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_2" x="186" y="126" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="53" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="189.753" y="143.13">53</tspan></text>\r\n</g>\r\n<g id="tier/place-52">\r\n<g id="place_5">\r\n<path id="oval_3" fill-rule="evenodd" clip-rule="evenodd" d="M264 114C265.105 114 266 113.105 266 112C266 110.895 265.105 110 264 110C262.895 110 262 110.895 262 112C262 113.105 262.895 114 264 114Z" fill="#9C9C9C"/>\r\n<rect id="place_6" x="252.5" y="100.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_3" x="252" y="100" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="52" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="255.753" y="117.13">52</tspan></text>\r\n</g>\r\n<g id="tier/place-51">\r\n<g id="place_7">\r\n<path id="oval_4" fill-rule="evenodd" clip-rule="evenodd" d="M264 140C265.105 140 266 139.105 266 138C266 136.895 265.105 136 264 136C262.895 136 262 136.895 262 138C262 139.105 262.895 140 264 140Z" fill="#9C9C9C"/>\r\n<rect id="place_8" x="252.5" y="126.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_4" x="252" y="126" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="51" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="255.753" y="143.13">51</tspan></text>\r\n</g>\r\n<g id="tier/place-50">\r\n<g id="place_9">\r\n<path id="oval_5" fill-rule="evenodd" clip-rule="evenodd" d="M330 114C331.105 114 332 113.105 332 112C332 110.895 331.105 110 330 110C328.895 110 328 110.895 328 112C328 113.105 328.895 114 330 114Z" fill="#9C9C9C"/>\r\n<rect id="place_10" x="318.5" y="100.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_5" x="318" y="100" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="50" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="321.753" y="117.13">50</tspan></text>\r\n</g>\r\n<g id="tier/place-49">\r\n<g id="place_11">\r\n<path id="oval_6" fill-rule="evenodd" clip-rule="evenodd" d="M330 140C331.105 140 332 139.105 332 138C332 136.895 331.105 136 330 136C328.895 136 328 136.895 328 138C328 139.105 328.895 140 330 140Z" fill="#9C9C9C"/>\r\n<rect id="place_12" x="318.5" y="126.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_6" x="318" y="126" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="49" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="321.753" y="143.13">49</tspan></text>\r\n</g>\r\n<g id="tier/place-48">\r\n<g id="place_13">\r\n<path id="oval_7" fill-rule="evenodd" clip-rule="evenodd" d="M396 114C397.105 114 398 113.105 398 112C398 110.895 397.105 110 396 110C394.895 110 394 110.895 394 112C394 113.105 394.895 114 396 114Z" fill="#9C9C9C"/>\r\n<rect id="place_14" x="384.5" y="100.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_7" x="384" y="100" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="48" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="387.753" y="117.13">48</tspan></text>\r\n</g>\r\n<g id="tier/place-47">\r\n<g id="place_15">\r\n<path id="oval_8" fill-rule="evenodd" clip-rule="evenodd" d="M396 140C397.105 140 398 139.105 398 138C398 136.895 397.105 136 396 136C394.895 136 394 136.895 394 138C394 139.105 394.895 140 396 140Z" fill="#9C9C9C"/>\r\n<rect id="place_16" x="384.5" y="126.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_8" x="384" y="126" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="47" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="387.753" y="143.13">47</tspan></text>\r\n</g>\r\n<g id="tier/place-46">\r\n<g id="place_17">\r\n<path id="oval_9" fill-rule="evenodd" clip-rule="evenodd" d="M462 114C463.105 114 464 113.105 464 112C464 110.895 463.105 110 462 110C460.895 110 460 110.895 460 112C460 113.105 460.895 114 462 114Z" fill="#9C9C9C"/>\r\n<rect id="place_18" x="450.5" y="100.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_9" x="450" y="100" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="46" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="453.753" y="117.13">46</tspan></text>\r\n</g>\r\n<g id="tier/place-45">\r\n<g id="place_19">\r\n<path id="oval_10" fill-rule="evenodd" clip-rule="evenodd" d="M462 140C463.105 140 464 139.105 464 138C464 136.895 463.105 136 462 136C460.895 136 460 136.895 460 138C460 139.105 460.895 140 462 140Z" fill="#9C9C9C"/>\r\n<rect id="place_20" x="450.5" y="126.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_10" x="450" y="126" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="45" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="453.753" y="143.13">45</tspan></text>\r\n</g>\r\n<g id="tier/place-44">\r\n<g id="place_21">\r\n<path id="oval_11" fill-rule="evenodd" clip-rule="evenodd" d="M528 114C529.105 114 530 113.105 530 112C530 110.895 529.105 110 528 110C526.895 110 526 110.895 526 112C526 113.105 526.895 114 528 114Z" fill="#9C9C9C"/>\r\n<rect id="place_22" x="516.5" y="100.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_11" x="516" y="100" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="44" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="519.753" y="117.13">44</tspan></text>\r\n</g>\r\n<g id="tier/place-43">\r\n<g id="place_23">\r\n<path id="oval_12" fill-rule="evenodd" clip-rule="evenodd" d="M528 140C529.105 140 530 139.105 530 138C530 136.895 529.105 136 528 136C526.895 136 526 136.895 526 138C526 139.105 526.895 140 528 140Z" fill="#9C9C9C"/>\r\n<rect id="place_24" x="516.5" y="126.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_12" x="516" y="126" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="43" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="519.753" y="143.13">43</tspan></text>\r\n</g>\r\n<g id="tier/place-42">\r\n<g id="place_25">\r\n<path id="oval_13" fill-rule="evenodd" clip-rule="evenodd" d="M594 114C595.105 114 596 113.105 596 112C596 110.895 595.105 110 594 110C592.895 110 592 110.895 592 112C592 113.105 592.895 114 594 114Z" fill="#9C9C9C"/>\r\n<rect id="place_26" x="582.5" y="100.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_13" x="582" y="100" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="42" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="585.753" y="117.13">42</tspan></text>\r\n</g>\r\n<g id="tier/place-41">\r\n<g id="place_27">\r\n<path id="oval_14" fill-rule="evenodd" clip-rule="evenodd" d="M594 140C595.105 140 596 139.105 596 138C596 136.895 595.105 136 594 136C592.895 136 592 136.895 592 138C592 139.105 592.895 140 594 140Z" fill="#9C9C9C"/>\r\n<rect id="place_28" x="582.5" y="126.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_14" x="582" y="126" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="41" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="585.753" y="143.13">41</tspan></text>\r\n</g>\r\n<g id="tier/place-40">\r\n<g id="place_29">\r\n<path id="oval_15" fill-rule="evenodd" clip-rule="evenodd" d="M660 114C661.105 114 662 113.105 662 112C662 110.895 661.105 110 660 110C658.895 110 658 110.895 658 112C658 113.105 658.895 114 660 114Z" fill="#9C9C9C"/>\r\n<rect id="place_30" x="648.5" y="100.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_15" x="648" y="100" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="40" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="651.753" y="117.13">40</tspan></text>\r\n</g>\r\n<g id="tier/place-39">\r\n<g id="place_31">\r\n<path id="oval_16" fill-rule="evenodd" clip-rule="evenodd" d="M660 140C661.105 140 662 139.105 662 138C662 136.895 661.105 136 660 136C658.895 136 658 136.895 658 138C658 139.105 658.895 140 660 140Z" fill="#9C9C9C"/>\r\n<rect id="place_32" x="648.5" y="126.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_16" x="648" y="126" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="39" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="651.753" y="143.13">39</tspan></text>\r\n</g>\r\n<g id="tier/place-38">\r\n<g id="place_33">\r\n<path id="oval_17" fill-rule="evenodd" clip-rule="evenodd" d="M726 114C727.105 114 728 113.105 728 112C728 110.895 727.105 110 726 110C724.895 110 724 110.895 724 112C724 113.105 724.895 114 726 114Z" fill="#9C9C9C"/>\r\n<rect id="place_34" x="714.5" y="100.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_17" x="714" y="100" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="38" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="717.753" y="117.13">38</tspan></text>\r\n</g>\r\n<g id="tier/place-37">\r\n<g id="place_35">\r\n<path id="oval_18" fill-rule="evenodd" clip-rule="evenodd" d="M726 140C727.105 140 728 139.105 728 138C728 136.895 727.105 136 726 136C724.895 136 724 136.895 724 138C724 139.105 724.895 140 726 140Z" fill="#9C9C9C"/>\r\n<rect id="place_36" x="714.5" y="126.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_18" x="714" y="126" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="37" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="717.753" y="143.13">37</tspan></text>\r\n</g>\r\n<g id="tier/place-36">\r\n<g id="place_37">\r\n<path id="oval_19" fill-rule="evenodd" clip-rule="evenodd" d="M726 36C727.105 36 728 35.1046 728 34C728 32.8954 727.105 32 726 32C724.895 32 724 32.8954 724 34C724 35.1046 724.895 36 726 36Z" fill="#9C9C9C"/>\r\n<rect id="place_38" x="714.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_19" x="714" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="36" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="717.753" y="39.13">36</tspan></text>\r\n</g>\r\n<g id="tier/place-35">\r\n<g id="place_39">\r\n<path id="oval_20" fill-rule="evenodd" clip-rule="evenodd" d="M726 62C727.105 62 728 61.1046 728 60C728 58.8954 727.105 58 726 58C724.895 58 724 58.8954 724 60C724 61.1046 724.895 62 726 62Z" fill="#9C9C9C"/>\r\n<rect id="place_40" x="714.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_20" x="714" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="35" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="717.753" y="65.13">35</tspan></text>\r\n</g>\r\n<g id="tier/place-34">\r\n<g id="place_41">\r\n<path id="oval_21" fill-rule="evenodd" clip-rule="evenodd" d="M700 36C701.105 36 702 35.1046 702 34C702 32.8954 701.105 32 700 32C698.895 32 698 32.8954 698 34C698 35.1046 698.895 36 700 36Z" fill="#9C9C9C"/>\r\n<rect id="place_42" x="688.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_21" x="688" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="34" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="691.753" y="39.13">34</tspan></text>\r\n</g>\r\n<g id="tier/place-33">\r\n<g id="place_43">\r\n<path id="oval_22" fill-rule="evenodd" clip-rule="evenodd" d="M700 62C701.105 62 702 61.1046 702 60C702 58.8954 701.105 58 700 58C698.895 58 698 58.8954 698 60C698 61.1046 698.895 62 700 62Z" fill="#9C9C9C"/>\r\n<rect id="place_44" x="688.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_22" x="688" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="33" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="691.753" y="65.13">33</tspan></text>\r\n</g>\r\n<g id="tier/place-32">\r\n<g id="place_45">\r\n<path id="oval_23" fill-rule="evenodd" clip-rule="evenodd" d="M660 36C661.105 36 662 35.1046 662 34C662 32.8954 661.105 32 660 32C658.895 32 658 32.8954 658 34C658 35.1046 658.895 36 660 36Z" fill="#9C9C9C"/>\r\n<rect id="place_46" x="648.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_23" x="648" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="32" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="651.753" y="39.13">32</tspan></text>\r\n</g>\r\n<g id="tier/place-31">\r\n<g id="place_47">\r\n<path id="oval_24" fill-rule="evenodd" clip-rule="evenodd" d="M660 62C661.105 62 662 61.1046 662 60C662 58.8954 661.105 58 660 58C658.895 58 658 58.8954 658 60C658 61.1046 658.895 62 660 62Z" fill="#9C9C9C"/>\r\n<rect id="place_48" x="648.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_24" x="648" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="31" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="651.753" y="65.13">31</tspan></text>\r\n</g>\r\n<g id="tier/place-30">\r\n<g id="place_49">\r\n<path id="oval_25" fill-rule="evenodd" clip-rule="evenodd" d="M634 36C635.105 36 636 35.1046 636 34C636 32.8954 635.105 32 634 32C632.895 32 632 32.8954 632 34C632 35.1046 632.895 36 634 36Z" fill="#9C9C9C"/>\r\n<rect id="place_50" x="622.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_25" x="622" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="30" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="625.753" y="39.13">30</tspan></text>\r\n</g>\r\n<g id="tier/place-29">\r\n<g id="place_51">\r\n<path id="oval_26" fill-rule="evenodd" clip-rule="evenodd" d="M634 62C635.105 62 636 61.1046 636 60C636 58.8954 635.105 58 634 58C632.895 58 632 58.8954 632 60C632 61.1046 632.895 62 634 62Z" fill="#9C9C9C"/>\r\n<rect id="place_52" x="622.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_26" x="622" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="29" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="625.753" y="65.13">29</tspan></text>\r\n</g>\r\n<g id="tier/place-28">\r\n<g id="place_53">\r\n<path id="oval_27" fill-rule="evenodd" clip-rule="evenodd" d="M594 36C595.105 36 596 35.1046 596 34C596 32.8954 595.105 32 594 32C592.895 32 592 32.8954 592 34C592 35.1046 592.895 36 594 36Z" fill="#9C9C9C"/>\r\n<rect id="place_54" x="582.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_27" x="582" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="28" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="585.753" y="39.13">28</tspan></text>\r\n</g>\r\n<g id="tier/place-27">\r\n<g id="place_55">\r\n<path id="oval_28" fill-rule="evenodd" clip-rule="evenodd" d="M594 62C595.105 62 596 61.1046 596 60C596 58.8954 595.105 58 594 58C592.895 58 592 58.8954 592 60C592 61.1046 592.895 62 594 62Z" fill="#9C9C9C"/>\r\n<rect id="place_56" x="582.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_28" x="582" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="27" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="585.753" y="65.13">27</tspan></text>\r\n</g>\r\n<g id="tier/place-26">\r\n<g id="place_57">\r\n<path id="oval_29" fill-rule="evenodd" clip-rule="evenodd" d="M568 36C569.105 36 570 35.1046 570 34C570 32.8954 569.105 32 568 32C566.895 32 566 32.8954 566 34C566 35.1046 566.895 36 568 36Z" fill="#9C9C9C"/>\r\n<rect id="place_58" x="556.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_29" x="556" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="26" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="559.753" y="39.13">26</tspan></text>\r\n</g>\r\n<g id="tier/place-25">\r\n<g id="place_59">\r\n<path id="oval_30" fill-rule="evenodd" clip-rule="evenodd" d="M568 62C569.105 62 570 61.1046 570 60C570 58.8954 569.105 58 568 58C566.895 58 566 58.8954 566 60C566 61.1046 566.895 62 568 62Z" fill="#9C9C9C"/>\r\n<rect id="place_60" x="556.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_30" x="556" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="25" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="559.753" y="65.13">25</tspan></text>\r\n</g>\r\n<g id="tier/place-24">\r\n<g id="place_61">\r\n<path id="oval_31" fill-rule="evenodd" clip-rule="evenodd" d="M528 36C529.105 36 530 35.1046 530 34C530 32.8954 529.105 32 528 32C526.895 32 526 32.8954 526 34C526 35.1046 526.895 36 528 36Z" fill="#9C9C9C"/>\r\n<rect id="place_62" x="516.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_31" x="516" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="24" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="519.753" y="39.13">24</tspan></text>\r\n</g>\r\n<g id="tier/place-23">\r\n<g id="place_63">\r\n<path id="oval_32" fill-rule="evenodd" clip-rule="evenodd" d="M528 62C529.105 62 530 61.1046 530 60C530 58.8954 529.105 58 528 58C526.895 58 526 58.8954 526 60C526 61.1046 526.895 62 528 62Z" fill="#9C9C9C"/>\r\n<rect id="place_64" x="516.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_32" x="516" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="23" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="519.753" y="65.13">23</tspan></text>\r\n</g>\r\n<g id="tier/place-22">\r\n<g id="place_65">\r\n<path id="oval_33" fill-rule="evenodd" clip-rule="evenodd" d="M502 36C503.105 36 504 35.1046 504 34C504 32.8954 503.105 32 502 32C500.895 32 500 32.8954 500 34C500 35.1046 500.895 36 502 36Z" fill="#9C9C9C"/>\r\n<rect id="place_66" x="490.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_33" x="490" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="22" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="493.753" y="39.13">22</tspan></text>\r\n</g>\r\n<g id="tier/place-21">\r\n<g id="place_67">\r\n<path id="oval_34" fill-rule="evenodd" clip-rule="evenodd" d="M502 62C503.105 62 504 61.1046 504 60C504 58.8954 503.105 58 502 58C500.895 58 500 58.8954 500 60C500 61.1046 500.895 62 502 62Z" fill="#9C9C9C"/>\r\n<rect id="place_68" x="490.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_34" x="490" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="21" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="493.753" y="65.13">21</tspan></text>\r\n</g>\r\n<g id="tier/place-20">\r\n<g id="place_69">\r\n<path id="oval_35" fill-rule="evenodd" clip-rule="evenodd" d="M462 36C463.105 36 464 35.1046 464 34C464 32.8954 463.105 32 462 32C460.895 32 460 32.8954 460 34C460 35.1046 460.895 36 462 36Z" fill="#9C9C9C"/>\r\n<rect id="place_70" x="450.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_35" x="450" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="20" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="453.753" y="39.13">20</tspan></text>\r\n</g>\r\n<g id="tier/place-19">\r\n<g id="place_71">\r\n<path id="oval_36" fill-rule="evenodd" clip-rule="evenodd" d="M462 62C463.105 62 464 61.1046 464 60C464 58.8954 463.105 58 462 58C460.895 58 460 58.8954 460 60C460 61.1046 460.895 62 462 62Z" fill="#9C9C9C"/>\r\n<rect id="place_72" x="450.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_36" x="450" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="19" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="453.753" y="65.13">19</tspan></text>\r\n</g>\r\n<g id="tier/place-18">\r\n<g id="place_73">\r\n<path id="oval_37" fill-rule="evenodd" clip-rule="evenodd" d="M436 36C437.105 36 438 35.1046 438 34C438 32.8954 437.105 32 436 32C434.895 32 434 32.8954 434 34C434 35.1046 434.895 36 436 36Z" fill="#9C9C9C"/>\r\n<rect id="place_74" x="424.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_37" x="424" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="18" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="427.753" y="39.13">18</tspan></text>\r\n</g>\r\n<g id="tier/place-17">\r\n<g id="place_75">\r\n<path id="oval_38" fill-rule="evenodd" clip-rule="evenodd" d="M436 62C437.105 62 438 61.1046 438 60C438 58.8954 437.105 58 436 58C434.895 58 434 58.8954 434 60C434 61.1046 434.895 62 436 62Z" fill="#9C9C9C"/>\r\n<rect id="place_76" x="424.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_38" x="424" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="17" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="427.753" y="65.13">17</tspan></text>\r\n</g>\r\n<g id="tier/place-16">\r\n<g id="place_77">\r\n<path id="oval_39" fill-rule="evenodd" clip-rule="evenodd" d="M396 36C397.105 36 398 35.1046 398 34C398 32.8954 397.105 32 396 32C394.895 32 394 32.8954 394 34C394 35.1046 394.895 36 396 36Z" fill="#9C9C9C"/>\r\n<rect id="place_78" x="384.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_39" x="384" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="16" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="387.753" y="39.13">16</tspan></text>\r\n</g>\r\n<g id="tier/place-15">\r\n<g id="place_79">\r\n<path id="oval_40" fill-rule="evenodd" clip-rule="evenodd" d="M396 62C397.105 62 398 61.1046 398 60C398 58.8954 397.105 58 396 58C394.895 58 394 58.8954 394 60C394 61.1046 394.895 62 396 62Z" fill="#9C9C9C"/>\r\n<rect id="place_80" x="384.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_40" x="384" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="15" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="387.753" y="65.13">15</tspan></text>\r\n</g>\r\n<g id="tier/place-14">\r\n<g id="place_81">\r\n<path id="oval_41" fill-rule="evenodd" clip-rule="evenodd" d="M370 36C371.105 36 372 35.1046 372 34C372 32.8954 371.105 32 370 32C368.895 32 368 32.8954 368 34C368 35.1046 368.895 36 370 36Z" fill="#9C9C9C"/>\r\n<rect id="place_82" x="358.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_41" x="358" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="14" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="361.753" y="39.13">14</tspan></text>\r\n</g>\r\n<g id="tier/place-13">\r\n<g id="place_83">\r\n<path id="oval_42" fill-rule="evenodd" clip-rule="evenodd" d="M370 62C371.105 62 372 61.1046 372 60C372 58.8954 371.105 58 370 58C368.895 58 368 58.8954 368 60C368 61.1046 368.895 62 370 62Z" fill="#9C9C9C"/>\r\n<rect id="place_84" x="358.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_42" x="358" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="13" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="361.753" y="65.13">13</tspan></text>\r\n</g>\r\n<g id="tier/place-12">\r\n<g id="place_85">\r\n<path id="oval_43" fill-rule="evenodd" clip-rule="evenodd" d="M330 36C331.105 36 332 35.1046 332 34C332 32.8954 331.105 32 330 32C328.895 32 328 32.8954 328 34C328 35.1046 328.895 36 330 36Z" fill="#9C9C9C"/>\r\n<rect id="place_86" x="318.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_43" x="318" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="12" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="321.753" y="39.13">12</tspan></text>\r\n</g>\r\n<g id="tier/place-11">\r\n<g id="place_87">\r\n<path id="oval_44" fill-rule="evenodd" clip-rule="evenodd" d="M330 62C331.105 62 332 61.1046 332 60C332 58.8954 331.105 58 330 58C328.895 58 328 58.8954 328 60C328 61.1046 328.895 62 330 62Z" fill="#9C9C9C"/>\r\n<rect id="place_88" x="318.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_44" x="318" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="11" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="321.753" y="65.13">11</tspan></text>\r\n</g>\r\n<g id="tier/place-10">\r\n<g id="place_89">\r\n<path id="oval_45" fill-rule="evenodd" clip-rule="evenodd" d="M304 36C305.105 36 306 35.1046 306 34C306 32.8954 305.105 32 304 32C302.895 32 302 32.8954 302 34C302 35.1046 302.895 36 304 36Z" fill="#9C9C9C"/>\r\n<rect id="place_90" x="292.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_45" x="292" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="10" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="295.753" y="39.13">10</tspan></text>\r\n</g>\r\n<g id="tier/place-09">\r\n<g id="place_91">\r\n<path id="oval_46" fill-rule="evenodd" clip-rule="evenodd" d="M304 62C305.105 62 306 61.1046 306 60C306 58.8954 305.105 58 304 58C302.895 58 302 58.8954 302 60C302 61.1046 302.895 62 304 62Z" fill="#9C9C9C"/>\r\n<rect id="place_92" x="292.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_46" x="292" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="9" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="299.876" y="65.13">9</tspan></text>\r\n</g>\r\n<g id="tier/place-08">\r\n<g id="place_93">\r\n<path id="oval_47" fill-rule="evenodd" clip-rule="evenodd" d="M264 36C265.105 36 266 35.1046 266 34C266 32.8954 265.105 32 264 32C262.895 32 262 32.8954 262 34C262 35.1046 262.895 36 264 36Z" fill="#9C9C9C"/>\r\n<rect id="place_94" x="252.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_47" x="252" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="8" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="259.876" y="39.13">8</tspan></text>\r\n</g>\r\n<g id="tier/place-07">\r\n<g id="place_95">\r\n<path id="oval_48" fill-rule="evenodd" clip-rule="evenodd" d="M264 62C265.105 62 266 61.1046 266 60C266 58.8954 265.105 58 264 58C262.895 58 262 58.8954 262 60C262 61.1046 262.895 62 264 62Z" fill="#9C9C9C"/>\r\n<rect id="place_96" x="252.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_48" x="252" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="7" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="259.876" y="65.13">7</tspan></text>\r\n</g>\r\n<g id="tier/place-06">\r\n<g id="place_97">\r\n<path id="oval_49" fill-rule="evenodd" clip-rule="evenodd" d="M238 36C239.105 36 240 35.1046 240 34C240 32.8954 239.105 32 238 32C236.895 32 236 32.8954 236 34C236 35.1046 236.895 36 238 36Z" fill="#9C9C9C"/>\r\n<rect id="place_98" x="226.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_49" x="226" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="6" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="233.876" y="39.13">6</tspan></text>\r\n</g>\r\n<g id="tier/place-05">\r\n<g id="place_99">\r\n<path id="oval_50" fill-rule="evenodd" clip-rule="evenodd" d="M238 62C239.105 62 240 61.1046 240 60C240 58.8954 239.105 58 238 58C236.895 58 236 58.8954 236 60C236 61.1046 236.895 62 238 62Z" fill="#9C9C9C"/>\r\n<rect id="place_100" x="226.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_50" x="226" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="5" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="233.876" y="65.13">5</tspan></text>\r\n</g>\r\n<g id="tier/place-04">\r\n<g id="place_101">\r\n<path id="oval_51" fill-rule="evenodd" clip-rule="evenodd" d="M198 36C199.105 36 200 35.1046 200 34C200 32.8954 199.105 32 198 32C196.895 32 196 32.8954 196 34C196 35.1046 196.895 36 198 36Z" fill="#9C9C9C"/>\r\n<rect id="place_102" x="186.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_51" x="186" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="4" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="193.876" y="39.13">4</tspan></text>\r\n</g>\r\n<g id="tier/place-03">\r\n<g id="place_103">\r\n<path id="oval_52" fill-rule="evenodd" clip-rule="evenodd" d="M198 62C199.105 62 200 61.1046 200 60C200 58.8954 199.105 58 198 58C196.895 58 196 58.8954 196 60C196 61.1046 196.895 62 198 62Z" fill="#9C9C9C"/>\r\n<rect id="place_104" x="186.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_52" x="186" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="3" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="193.876" y="65.13">3</tspan></text>\r\n</g>\r\n<g id="tier/place-02">\r\n<g id="place_105">\r\n<path id="oval_53" fill-rule="evenodd" clip-rule="evenodd" d="M172 36C173.105 36 174 35.1046 174 34C174 32.8954 173.105 32 172 32C170.895 32 170 32.8954 170 34C170 35.1046 170.895 36 172 36Z" fill="#9C9C9C"/>\r\n<rect id="place_106" x="160.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_53" x="160" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="2" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="167.876" y="39.13">2</tspan></text>\r\n</g>\r\n<g id="tier/place-01">\r\n<g id="place_107">\r\n<path id="oval_54" fill-rule="evenodd" clip-rule="evenodd" d="M172 62C173.105 62 174 61.1046 174 60C174 58.8954 173.105 58 172 58C170.895 58 170 58.8954 170 60C170 61.1046 170.895 62 172 62Z" fill="#9C9C9C"/>\r\n<rect id="place_108" x="160.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_54" x="160" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.1"/>\r\n</g>\r\n<text id="1" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="167.876" y="65.13">1</tspan></text>\r\n</g>\r\n</g>\r\n</g>\r\n</g>\r\n</svg>',
                placeSelectionAlgorithm: 'two-level',
                height: 173,
                width: 699,
                placeFlags: {
                    upper: [
                        2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30,
                        32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54,
                    ],
                    lower: [
                        1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29,
                        31, 33, 35, 37, 39, 41, 43, 45, 47, 49, 51, 53,
                    ],
                    compartments: [
                        [1, 2, 3, 4],
                        [5, 6, 7, 8],
                        [9, 10, 11, 12],
                        [13, 14, 15, 16],
                        [17, 18, 19, 20],
                        [21, 22, 23, 24],
                        [25, 26, 27, 28],
                        [29, 30, 31, 32],
                        [33, 34, 35, 36],
                    ],
                    nearToilet: [33, 34, 35, 36, 37, 38],
                    sections: [
                        [1, 2, 3, 4, 53, 54],
                        [5, 6, 7, 8, 51, 52],
                        [9, 10, 11, 12, 49, 50],
                        [13, 14, 15, 16, 47, 48],
                        [17, 18, 19, 20, 45, 46],
                        [21, 22, 23, 24, 43, 44],
                        [25, 26, 27, 28, 41, 42],
                        [29, 30, 31, 32, 39, 40],
                        [33, 34, 35, 36, 37, 38],
                    ],
                    side: [
                        37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
                        51, 52, 53, 54,
                    ],
                } as ISchemaPlaceFlags,
                id: 2,
            },
            '3': {
                hidePlaceNumbers: false,
                places: [
                    {
                        geometry: {top: 22, left: 110},
                        groupNumber: 1,
                        number: 37,
                    },
                    {geometry: {top: 0, left: 110}, groupNumber: 1, number: 38},
                    {geometry: {top: 22, left: 140}, groupNumber: 2, number: 1},
                    {geometry: {top: 0, left: 140}, groupNumber: 2, number: 2},
                    {geometry: {top: 22, left: 163}, groupNumber: 2, number: 3},
                    {geometry: {top: 0, left: 163}, groupNumber: 2, number: 4},
                    {geometry: {top: 22, left: 193}, groupNumber: 3, number: 5},
                    {geometry: {top: 0, left: 193}, groupNumber: 3, number: 6},
                    {geometry: {top: 22, left: 216}, groupNumber: 3, number: 7},
                    {geometry: {top: 0, left: 216}, groupNumber: 3, number: 8},
                    {geometry: {top: 22, left: 246}, groupNumber: 4, number: 9},
                    {geometry: {top: 0, left: 246}, groupNumber: 4, number: 10},
                    {
                        geometry: {top: 22, left: 269},
                        groupNumber: 4,
                        number: 11,
                    },
                    {geometry: {top: 0, left: 269}, groupNumber: 4, number: 12},
                    {
                        geometry: {top: 22, left: 299},
                        groupNumber: 5,
                        number: 13,
                    },
                    {geometry: {top: 0, left: 299}, groupNumber: 5, number: 14},
                    {
                        geometry: {top: 22, left: 322},
                        groupNumber: 5,
                        number: 15,
                    },
                    {geometry: {top: 0, left: 322}, groupNumber: 5, number: 16},
                    {
                        geometry: {top: 22, left: 352},
                        groupNumber: 6,
                        number: 17,
                    },
                    {geometry: {top: 0, left: 352}, groupNumber: 6, number: 18},
                    {
                        geometry: {top: 22, left: 375},
                        groupNumber: 6,
                        number: 19,
                    },
                    {geometry: {top: 0, left: 375}, groupNumber: 6, number: 20},
                    {
                        geometry: {top: 22, left: 405},
                        groupNumber: 7,
                        number: 21,
                    },
                    {geometry: {top: 0, left: 405}, groupNumber: 7, number: 22},
                    {
                        geometry: {top: 22, left: 428},
                        groupNumber: 7,
                        number: 23,
                    },
                    {geometry: {top: 0, left: 428}, groupNumber: 7, number: 24},
                    {
                        geometry: {top: 22, left: 458},
                        groupNumber: 8,
                        number: 25,
                    },
                    {geometry: {top: 0, left: 458}, groupNumber: 8, number: 26},
                    {
                        geometry: {top: 22, left: 481},
                        groupNumber: 8,
                        number: 27,
                    },
                    {geometry: {top: 0, left: 481}, groupNumber: 8, number: 28},
                    {
                        geometry: {top: 22, left: 511},
                        groupNumber: 9,
                        number: 29,
                    },
                    {geometry: {top: 0, left: 511}, groupNumber: 9, number: 30},
                    {
                        geometry: {top: 22, left: 534},
                        groupNumber: 9,
                        number: 31,
                    },
                    {geometry: {top: 0, left: 534}, groupNumber: 9, number: 32},
                    {
                        geometry: {top: 22, left: 564},
                        groupNumber: 10,
                        number: 33,
                    },
                    {
                        geometry: {top: 0, left: 564},
                        groupNumber: 10,
                        number: 34,
                    },
                    {
                        geometry: {top: 22, left: 587},
                        groupNumber: 10,
                        number: 35,
                    },
                    {
                        geometry: {top: 0, left: 587},
                        groupNumber: 10,
                        number: 36,
                    },
                ],
                url: '//yastatic.net/s3/rasp/media/data/coachinfo/image/compartment2_3.png',
                svg: '<svg width="756" height="134" viewBox="0 0 756 134" fill="none" xmlns="http://www.w3.org/2000/svg">\r\n<rect width="756" height="134" fill="#F2F2F2"/>\r\n<g id="&#208;&#154;&#209;&#131;&#208;&#191;&#208;&#181;, 38 &#208;&#188;&#208;&#181;&#209;&#129;&#209;&#130;">\r\n<rect width="756" height="134" fill="white"/>\r\n<g id="scheme">\r\n<g id="base">\r\n<rect id="base_2" x="1" y="5" width="754" height="124" rx="7" fill="white" stroke="#CFCFCF" stroke-width="2"/>\r\n<text id="&#208;&#178;&#208;&#181;&#209;&#128;&#209;&#133;&#208;&#189;&#208;&#184;&#208;&#181;" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="12" letter-spacing="0px"><tspan x="18" y="39.136">&#x432;&#x435;&#x440;&#x445;&#x43d;&#x438;&#x435;</tspan></text>\r\n<text id="&#208;&#189;&#208;&#184;&#208;&#182;&#208;&#189;&#208;&#184;&#208;&#181;" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="12" letter-spacing="0px"><tspan x="18" y="65.136">&#x43d;&#x438;&#x436;&#x43d;&#x438;&#x435;</tspan></text>\r\n<g id="enters/enter-bottom">\r\n<rect id="Path" x="18" y="118" width="20" height="12" fill="white"/>\r\n<path id="Combined Shape" fill-rule="evenodd" clip-rule="evenodd" d="M38 130H36V120H20V130H18V118H38V130ZM24 130L28 124L32 130H29V134H27V130H24Z" fill="#CFCFCF"/>\r\n</g>\r\n<g id="enters/enter-top">\r\n<rect id="Path_2" x="18" y="4" width="20" height="12" fill="white"/>\r\n<path id="Combined Shape_2" fill-rule="evenodd" clip-rule="evenodd" d="M29 4V0H27V4H24L28 10L32 4H29ZM36 4V14H20V4H18V16H38V4H36Z" fill="#CFCFCF"/>\r\n</g>\r\n</g>\r\n<g id="warp">\r\n<g id="warp/warp-32-58">\r\n<rect id="warp-32-58" x="116" y="18" width="32" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-58-58">\r\n<rect id="warp-58-58" x="156" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-58-58_2">\r\n<rect id="warp-58-58_2" x="222" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-58-58_3">\r\n<rect id="warp-58-58_3" x="288" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-58-58_4">\r\n<rect id="warp-58-58_4" x="354" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-58-58_5">\r\n<rect id="warp-58-58_5" x="420" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-58-58_6">\r\n<rect id="warp-58-58_6" x="486" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-58-58_7">\r\n<rect id="warp-58-58_7" x="552" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-58-58_8">\r\n<rect id="warp-58-58_8" x="618" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n<g id="warp/warp-58-58_9">\r\n<rect id="warp-58-58_9" x="684" y="18" width="58" height="58" rx="4" fill="#EAEAEA"/>\r\n</g>\r\n</g>\r\n<g id="places">\r\n<g id="tier/place-38">\r\n<g id="place">\r\n<path id="oval" fill-rule="evenodd" clip-rule="evenodd" d="M132 36C133.105 36 134 35.1046 134 34C134 32.8954 133.105 32 132 32C130.895 32 130 32.8954 130 34C130 35.1046 130.895 36 132 36Z" fill="#9C9C9C"/>\r\n<rect id="place_2" x="120.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger" x="120" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="38" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="123.753" y="39.13">38</tspan></text>\r\n</g>\r\n<g id="tier/place-37">\r\n<g id="place_3">\r\n<path id="oval_2" fill-rule="evenodd" clip-rule="evenodd" d="M132 62C133.105 62 134 61.1046 134 60C134 58.8954 133.105 58 132 58C130.895 58 130 58.8954 130 60C130 61.1046 130.895 62 132 62Z" fill="#9C9C9C"/>\r\n<rect id="place_4" x="120.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_2" x="120" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="37" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="123.753" y="65.13">37</tspan></text>\r\n</g>\r\n<g id="tier/place-36">\r\n<g id="place_5">\r\n<path id="oval_3" fill-rule="evenodd" clip-rule="evenodd" d="M726 36C727.105 36 728 35.1046 728 34C728 32.8954 727.105 32 726 32C724.895 32 724 32.8954 724 34C724 35.1046 724.895 36 726 36Z" fill="#9C9C9C"/>\r\n<rect id="place_6" x="714.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_3" x="714" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="36" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="717.753" y="39.13">36</tspan></text>\r\n</g>\r\n<g id="tier/place-35">\r\n<g id="place_7">\r\n<path id="oval_4" fill-rule="evenodd" clip-rule="evenodd" d="M726 62C727.105 62 728 61.1046 728 60C728 58.8954 727.105 58 726 58C724.895 58 724 58.8954 724 60C724 61.1046 724.895 62 726 62Z" fill="#9C9C9C"/>\r\n<rect id="place_8" x="714.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_4" x="714" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="35" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="717.753" y="65.13">35</tspan></text>\r\n</g>\r\n<g id="tier/place-34">\r\n<g id="place_9">\r\n<path id="oval_5" fill-rule="evenodd" clip-rule="evenodd" d="M700 36C701.105 36 702 35.1046 702 34C702 32.8954 701.105 32 700 32C698.895 32 698 32.8954 698 34C698 35.1046 698.895 36 700 36Z" fill="#9C9C9C"/>\r\n<rect id="place_10" x="688.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_5" x="688" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="34" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="691.753" y="39.13">34</tspan></text>\r\n</g>\r\n<g id="tier/place-33">\r\n<g id="place_11">\r\n<path id="oval_6" fill-rule="evenodd" clip-rule="evenodd" d="M700 62C701.105 62 702 61.1046 702 60C702 58.8954 701.105 58 700 58C698.895 58 698 58.8954 698 60C698 61.1046 698.895 62 700 62Z" fill="#9C9C9C"/>\r\n<rect id="place_12" x="688.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_6" x="688" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="33" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="691.753" y="65.13">33</tspan></text>\r\n</g>\r\n<g id="tier/place-32">\r\n<g id="place_13">\r\n<path id="oval_7" fill-rule="evenodd" clip-rule="evenodd" d="M660 36C661.105 36 662 35.1046 662 34C662 32.8954 661.105 32 660 32C658.895 32 658 32.8954 658 34C658 35.1046 658.895 36 660 36Z" fill="#9C9C9C"/>\r\n<rect id="place_14" x="648.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_7" x="648" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="32" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="651.753" y="39.13">32</tspan></text>\r\n</g>\r\n<g id="tier/place-31">\r\n<g id="place_15">\r\n<path id="oval_8" fill-rule="evenodd" clip-rule="evenodd" d="M660 62C661.105 62 662 61.1046 662 60C662 58.8954 661.105 58 660 58C658.895 58 658 58.8954 658 60C658 61.1046 658.895 62 660 62Z" fill="#9C9C9C"/>\r\n<rect id="place_16" x="648.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_8" x="648" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="31" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="651.753" y="65.13">31</tspan></text>\r\n</g>\r\n<g id="tier/place-30">\r\n<g id="place_17">\r\n<path id="oval_9" fill-rule="evenodd" clip-rule="evenodd" d="M634 36C635.105 36 636 35.1046 636 34C636 32.8954 635.105 32 634 32C632.895 32 632 32.8954 632 34C632 35.1046 632.895 36 634 36Z" fill="#9C9C9C"/>\r\n<rect id="place_18" x="622.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_9" x="622" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="30" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="625.753" y="39.13">30</tspan></text>\r\n</g>\r\n<g id="tier/place-29">\r\n<g id="place_19">\r\n<path id="oval_10" fill-rule="evenodd" clip-rule="evenodd" d="M634 62C635.105 62 636 61.1046 636 60C636 58.8954 635.105 58 634 58C632.895 58 632 58.8954 632 60C632 61.1046 632.895 62 634 62Z" fill="#9C9C9C"/>\r\n<rect id="place_20" x="622.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_10" x="622" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="29" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="625.753" y="65.13">29</tspan></text>\r\n</g>\r\n<g id="tier/place-28">\r\n<g id="place_21">\r\n<path id="oval_11" fill-rule="evenodd" clip-rule="evenodd" d="M594 36C595.105 36 596 35.1046 596 34C596 32.8954 595.105 32 594 32C592.895 32 592 32.8954 592 34C592 35.1046 592.895 36 594 36Z" fill="#9C9C9C"/>\r\n<rect id="place_22" x="582.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_11" x="582" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="28" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="585.753" y="39.13">28</tspan></text>\r\n</g>\r\n<g id="tier/place-27">\r\n<g id="place_23">\r\n<path id="oval_12" fill-rule="evenodd" clip-rule="evenodd" d="M594 62C595.105 62 596 61.1046 596 60C596 58.8954 595.105 58 594 58C592.895 58 592 58.8954 592 60C592 61.1046 592.895 62 594 62Z" fill="#9C9C9C"/>\r\n<rect id="place_24" x="582.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_12" x="582" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="27" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="585.753" y="65.13">27</tspan></text>\r\n</g>\r\n<g id="tier/place-26">\r\n<g id="place_25">\r\n<path id="oval_13" fill-rule="evenodd" clip-rule="evenodd" d="M568 36C569.105 36 570 35.1046 570 34C570 32.8954 569.105 32 568 32C566.895 32 566 32.8954 566 34C566 35.1046 566.895 36 568 36Z" fill="#9C9C9C"/>\r\n<rect id="place_26" x="556.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_13" x="556" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="26" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="559.753" y="39.13">26</tspan></text>\r\n</g>\r\n<g id="tier/place-25">\r\n<g id="place_27">\r\n<path id="oval_14" fill-rule="evenodd" clip-rule="evenodd" d="M568 62C569.105 62 570 61.1046 570 60C570 58.8954 569.105 58 568 58C566.895 58 566 58.8954 566 60C566 61.1046 566.895 62 568 62Z" fill="#9C9C9C"/>\r\n<rect id="place_28" x="556.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_14" x="556" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="25" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="559.753" y="65.13">25</tspan></text>\r\n</g>\r\n<g id="tier/place-24">\r\n<g id="place_29">\r\n<path id="oval_15" fill-rule="evenodd" clip-rule="evenodd" d="M528 36C529.105 36 530 35.1046 530 34C530 32.8954 529.105 32 528 32C526.895 32 526 32.8954 526 34C526 35.1046 526.895 36 528 36Z" fill="#9C9C9C"/>\r\n<rect id="place_30" x="516.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_15" x="516" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="24" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="519.753" y="39.13">24</tspan></text>\r\n</g>\r\n<g id="tier/place-23">\r\n<g id="place_31">\r\n<path id="oval_16" fill-rule="evenodd" clip-rule="evenodd" d="M528 62C529.105 62 530 61.1046 530 60C530 58.8954 529.105 58 528 58C526.895 58 526 58.8954 526 60C526 61.1046 526.895 62 528 62Z" fill="#9C9C9C"/>\r\n<rect id="place_32" x="516.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_16" x="516" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="23" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="519.753" y="65.13">23</tspan></text>\r\n</g>\r\n<g id="tier/place-22">\r\n<g id="place_33">\r\n<path id="oval_17" fill-rule="evenodd" clip-rule="evenodd" d="M502 36C503.105 36 504 35.1046 504 34C504 32.8954 503.105 32 502 32C500.895 32 500 32.8954 500 34C500 35.1046 500.895 36 502 36Z" fill="#9C9C9C"/>\r\n<rect id="place_34" x="490.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_17" x="490" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="22" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="493.753" y="39.13">22</tspan></text>\r\n</g>\r\n<g id="tier/place-21">\r\n<g id="place_35">\r\n<path id="oval_18" fill-rule="evenodd" clip-rule="evenodd" d="M502 62C503.105 62 504 61.1046 504 60C504 58.8954 503.105 58 502 58C500.895 58 500 58.8954 500 60C500 61.1046 500.895 62 502 62Z" fill="#9C9C9C"/>\r\n<rect id="place_36" x="490.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_18" x="490" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="21" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="493.753" y="65.13">21</tspan></text>\r\n</g>\r\n<g id="tier/place-20">\r\n<g id="place_37">\r\n<path id="oval_19" fill-rule="evenodd" clip-rule="evenodd" d="M462 36C463.105 36 464 35.1046 464 34C464 32.8954 463.105 32 462 32C460.895 32 460 32.8954 460 34C460 35.1046 460.895 36 462 36Z" fill="#9C9C9C"/>\r\n<rect id="place_38" x="450.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_19" x="450" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="20" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="453.753" y="39.13">20</tspan></text>\r\n</g>\r\n<g id="tier/place-19">\r\n<g id="place_39">\r\n<path id="oval_20" fill-rule="evenodd" clip-rule="evenodd" d="M462 62C463.105 62 464 61.1046 464 60C464 58.8954 463.105 58 462 58C460.895 58 460 58.8954 460 60C460 61.1046 460.895 62 462 62Z" fill="#9C9C9C"/>\r\n<rect id="place_40" x="450.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_20" x="450" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="19" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="453.753" y="65.13">19</tspan></text>\r\n</g>\r\n<g id="tier/place-18">\r\n<g id="place_41">\r\n<path id="oval_21" fill-rule="evenodd" clip-rule="evenodd" d="M436 36C437.105 36 438 35.1046 438 34C438 32.8954 437.105 32 436 32C434.895 32 434 32.8954 434 34C434 35.1046 434.895 36 436 36Z" fill="#9C9C9C"/>\r\n<rect id="place_42" x="424.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_21" x="424" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="18" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="427.753" y="39.13">18</tspan></text>\r\n</g>\r\n<g id="tier/place-17">\r\n<g id="place_43">\r\n<path id="oval_22" fill-rule="evenodd" clip-rule="evenodd" d="M436 62C437.105 62 438 61.1046 438 60C438 58.8954 437.105 58 436 58C434.895 58 434 58.8954 434 60C434 61.1046 434.895 62 436 62Z" fill="#9C9C9C"/>\r\n<rect id="place_44" x="424.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_22" x="424" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="17" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="427.753" y="65.13">17</tspan></text>\r\n</g>\r\n<g id="tier/place-16">\r\n<g id="place_45">\r\n<path id="oval_23" fill-rule="evenodd" clip-rule="evenodd" d="M396 36C397.105 36 398 35.1046 398 34C398 32.8954 397.105 32 396 32C394.895 32 394 32.8954 394 34C394 35.1046 394.895 36 396 36Z" fill="#9C9C9C"/>\r\n<rect id="place_46" x="384.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_23" x="384" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="16" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="387.753" y="39.13">16</tspan></text>\r\n</g>\r\n<g id="tier/place-15">\r\n<g id="place_47">\r\n<path id="oval_24" fill-rule="evenodd" clip-rule="evenodd" d="M396 62C397.105 62 398 61.1046 398 60C398 58.8954 397.105 58 396 58C394.895 58 394 58.8954 394 60C394 61.1046 394.895 62 396 62Z" fill="#9C9C9C"/>\r\n<rect id="place_48" x="384.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_24" x="384" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="15" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="387.753" y="65.13">15</tspan></text>\r\n</g>\r\n<g id="tier/place-14">\r\n<g id="place_49">\r\n<path id="oval_25" fill-rule="evenodd" clip-rule="evenodd" d="M370 36C371.105 36 372 35.1046 372 34C372 32.8954 371.105 32 370 32C368.895 32 368 32.8954 368 34C368 35.1046 368.895 36 370 36Z" fill="#9C9C9C"/>\r\n<rect id="place_50" x="358.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_25" x="358" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="14" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="361.753" y="39.13">14</tspan></text>\r\n</g>\r\n<g id="tier/place-13">\r\n<g id="place_51">\r\n<path id="oval_26" fill-rule="evenodd" clip-rule="evenodd" d="M370 62C371.105 62 372 61.1046 372 60C372 58.8954 371.105 58 370 58C368.895 58 368 58.8954 368 60C368 61.1046 368.895 62 370 62Z" fill="#9C9C9C"/>\r\n<rect id="place_52" x="358.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_26" x="358" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="13" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="361.753" y="65.13">13</tspan></text>\r\n</g>\r\n<g id="tier/place-12">\r\n<g id="place_53">\r\n<path id="oval_27" fill-rule="evenodd" clip-rule="evenodd" d="M330 36C331.105 36 332 35.1046 332 34C332 32.8954 331.105 32 330 32C328.895 32 328 32.8954 328 34C328 35.1046 328.895 36 330 36Z" fill="#9C9C9C"/>\r\n<rect id="place_54" x="318.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_27" x="318" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="12" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="321.753" y="39.13">12</tspan></text>\r\n</g>\r\n<g id="tier/place-11">\r\n<g id="place_55">\r\n<path id="oval_28" fill-rule="evenodd" clip-rule="evenodd" d="M330 62C331.105 62 332 61.1046 332 60C332 58.8954 331.105 58 330 58C328.895 58 328 58.8954 328 60C328 61.1046 328.895 62 330 62Z" fill="#9C9C9C"/>\r\n<rect id="place_56" x="318.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_28" x="318" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="11" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="321.753" y="65.13">11</tspan></text>\r\n</g>\r\n<g id="tier/place-10">\r\n<g id="place_57">\r\n<path id="oval_29" fill-rule="evenodd" clip-rule="evenodd" d="M304 36C305.105 36 306 35.1046 306 34C306 32.8954 305.105 32 304 32C302.895 32 302 32.8954 302 34C302 35.1046 302.895 36 304 36Z" fill="#9C9C9C"/>\r\n<rect id="place_58" x="292.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_29" x="292" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="10" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="295.753" y="39.13">10</tspan></text>\r\n</g>\r\n<g id="tier/place-09">\r\n<g id="place_59">\r\n<path id="oval_30" fill-rule="evenodd" clip-rule="evenodd" d="M304 62C305.105 62 306 61.1046 306 60C306 58.8954 305.105 58 304 58C302.895 58 302 58.8954 302 60C302 61.1046 302.895 62 304 62Z" fill="#9C9C9C"/>\r\n<rect id="place_60" x="292.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_30" x="292" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="9" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="299.876" y="65.13">9</tspan></text>\r\n</g>\r\n<g id="tier/place-08">\r\n<g id="place_61">\r\n<path id="oval_31" fill-rule="evenodd" clip-rule="evenodd" d="M264 36C265.105 36 266 35.1046 266 34C266 32.8954 265.105 32 264 32C262.895 32 262 32.8954 262 34C262 35.1046 262.895 36 264 36Z" fill="#9C9C9C"/>\r\n<rect id="place_62" x="252.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_31" x="252" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="8" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="259.876" y="39.13">8</tspan></text>\r\n</g>\r\n<g id="tier/place-07">\r\n<g id="place_63">\r\n<path id="oval_32" fill-rule="evenodd" clip-rule="evenodd" d="M264 62C265.105 62 266 61.1046 266 60C266 58.8954 265.105 58 264 58C262.895 58 262 58.8954 262 60C262 61.1046 262.895 62 264 62Z" fill="#9C9C9C"/>\r\n<rect id="place_64" x="252.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_32" x="252" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="7" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="259.876" y="65.13">7</tspan></text>\r\n</g>\r\n<g id="tier/place-06">\r\n<g id="place_65">\r\n<path id="oval_33" fill-rule="evenodd" clip-rule="evenodd" d="M238 36C239.105 36 240 35.1046 240 34C240 32.8954 239.105 32 238 32C236.895 32 236 32.8954 236 34C236 35.1046 236.895 36 238 36Z" fill="#9C9C9C"/>\r\n<rect id="place_66" x="226.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_33" x="226" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="6" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="233.876" y="39.13">6</tspan></text>\r\n</g>\r\n<g id="tier/place-05">\r\n<g id="place_67">\r\n<path id="oval_34" fill-rule="evenodd" clip-rule="evenodd" d="M238 62C239.105 62 240 61.1046 240 60C240 58.8954 239.105 58 238 58C236.895 58 236 58.8954 236 60C236 61.1046 236.895 62 238 62Z" fill="#9C9C9C"/>\r\n<rect id="place_68" x="226.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_34" x="226" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="5" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="233.876" y="65.13">5</tspan></text>\r\n</g>\r\n<g id="tier/place-04">\r\n<g id="place_69">\r\n<path id="oval_35" fill-rule="evenodd" clip-rule="evenodd" d="M198 36C199.105 36 200 35.1046 200 34C200 32.8954 199.105 32 198 32C196.895 32 196 32.8954 196 34C196 35.1046 196.895 36 198 36Z" fill="#9C9C9C"/>\r\n<rect id="place_70" x="186.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_35" x="186" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="4" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="193.876" y="39.13">4</tspan></text>\r\n</g>\r\n<g id="tier/place-03">\r\n<g id="place_71">\r\n<path id="oval_36" fill-rule="evenodd" clip-rule="evenodd" d="M198 62C199.105 62 200 61.1046 200 60C200 58.8954 199.105 58 198 58C196.895 58 196 58.8954 196 60C196 61.1046 196.895 62 198 62Z" fill="#9C9C9C"/>\r\n<rect id="place_72" x="186.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_36" x="186" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="3" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="193.876" y="65.13">3</tspan></text>\r\n</g>\r\n<g id="tier/place-02">\r\n<g id="place_73">\r\n<path id="oval_37" fill-rule="evenodd" clip-rule="evenodd" d="M172 36C173.105 36 174 35.1046 174 34C174 32.8954 173.105 32 172 32C170.895 32 170 32.8954 170 34C170 35.1046 170.895 36 172 36Z" fill="#9C9C9C"/>\r\n<rect id="place_74" x="160.5" y="22.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_37" x="160" y="22" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="2" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="167.876" y="39.13">2</tspan></text>\r\n</g>\r\n<g id="tier/place-01">\r\n<g id="place_75">\r\n<path id="oval_38" fill-rule="evenodd" clip-rule="evenodd" d="M172 62C173.105 62 174 61.1046 174 60C174 58.8954 173.105 58 172 58C170.895 58 170 58.8954 170 60C170 61.1046 170.895 62 172 62Z" fill="#9C9C9C"/>\r\n<rect id="place_76" x="160.5" y="48.5" width="23" height="23" rx="1.5" fill="white" stroke="#999999"/>\r\n<rect id="trigger_38" x="160" y="48" width="24" height="24" rx="2" fill="white" fill-opacity="0.01"/>\r\n</g>\r\n<text id="1" fill="#222222" xml:space="preserve" style="white-space: pre" font-family="YS Text" font-size="15" letter-spacing="0px"><tspan x="167.876" y="65.13">1</tspan></text>\r\n</g>\r\n</g>\r\n</g>\r\n</g>\r\n</svg>',
                placeSelectionAlgorithm: 'two-level',
                height: 173,
                width: 699,
                placeFlags: {
                    upper: [
                        2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30,
                        32, 34, 36, 38,
                    ],
                    lower: [
                        1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29,
                        31, 33, 35, 37,
                    ],
                    twinRoom: [37, 38],
                    compartments: [
                        [37, 38],
                        [1, 2, 3, 4],
                        [5, 6, 7, 8],
                        [9, 10, 11, 12],
                        [13, 14, 15, 16],
                        [17, 18, 19, 20],
                        [21, 22, 23, 24],
                        [25, 26, 27, 28],
                        [29, 30, 31, 32],
                        [33, 34, 35, 36],
                    ],
                } as ISchemaPlaceFlags,
                id: 3,
            },
        },
    },
    errors: false,
    partnerError: null,
};

export default trainDetails;
