import {EOrderErrorType} from 'projects/trains/constants/orderErrors';

import {IOrderError} from 'reducers/trains/order/types';
import IErrorInfo from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/IErrorInfo/IErrorInfo';

import * as i18nBlock from 'i18n/trains-error-page-order';

import prepareOrderErrorType from 'server/services/TrainsService/prepareData/prepareOrderErrorType';

export default function prepareOrderError(
    error: IErrorInfo | null,
): IOrderError | null {
    if (!error) {
        return null;
    }

    const type = prepareOrderErrorType(error.type);

    const message =
        error.message ||
        (type === EOrderErrorType.COMMON
            ? i18nBlock.commonDashErrorDashDescription()
            : undefined);

    return {
        type,
        message,
        params: error.messageParams || undefined,
    };
}
