import {IUserParams} from 'server/services/TrainsService/types/IUserParams';
import {ITrainsSource} from 'server/api/TrainsApi/types/ITrainsSource';
import IAttributionData from 'server/utilities/DataStorage/AttributionData/types/IAttributionData';
import IUserData from 'server/utilities/DataStorage/UserData/types/IUserData';

import AffiliateData from 'server/utilities/DataStorage/AffiliateData/AffiliateData';

export default function prepareOrderLabelParams({
    attributionData,
    affiliateData,
    userData,
    userParams,
    isTransfer,
    ytpReferer,
}: {
    attributionData: IAttributionData;
    affiliateData: AffiliateData;
    userData: IUserData;
    userParams: IUserParams;
    isTransfer: boolean;
    ytpReferer: string | undefined;
}): ITrainsSource {
    const utm = attributionData.getUtm();
    const affiliateParams = affiliateData.getParams();

    return {
        reqId: attributionData.getSerpReqId(),
        utmSource: utm.utmSource,
        utmMedium: utm.utmMedium,
        utmCampaign: utm.utmCampaign,
        utmTerm: utm.utmTerm,
        utmContent: utm.utmContent,
        from: attributionData.getFrom(),
        gclid: attributionData.getGclid(),
        yclid: attributionData.getYclid(),
        fbclid: attributionData.getFbclid(),
        device: userData.getDeviceType(),
        icookie: userData.getICookie(),
        serpUuid: attributionData.getSerpUuid(),
        testBuckets: attributionData.getUaas().testBuckets,
        terminal: 'travel',
        isTransfer,
        yandexUid: userData.getYandexUid(),
        uid: userData.getPassportId(),
        ip: userParams.ip,
        regionId: userParams.geoId,
        serp_test_id: attributionData.getSerpTestId(),
        ytpReferer,
        metrikaClientId: userData.getMetrikaClientId(),
        ...affiliateParams,
    };
}
