import {
    ITrainsCoachServer,
    TrainPlaceType,
} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';
import {ITrainsCoachApi} from 'server/services/TrainsService/types/ITrainsDetailsInfoServiceResponse';

import {trainsSortCoachTariffs} from 'projects/trains/lib/order/trainsSortCoachTariffs';
import getCoachCategoryByServiceClass from 'server/services/TrainsService/prepareData/utilities/getCoachCategoryByServiceClass';
import getCoachCategoryByCoachType from 'server/services/TrainsService/prepareData/utilities/getCoachCategoryByCoachType';

export function prepareTrainsDetailsCoach({
    coach,
    index,
    useServiceClasses,
}: {
    coach: ITrainsCoachServer;
    index: number;
    useServiceClasses: boolean;
}): ITrainsCoachApi {
    /**
     * Расширяем вагоны полем category.
     * В поле category может содержаться либо информация о типе поезда, либо о классах обслуживания
     */
    const preparedCoach = {
        ...coach,
        category: useServiceClasses
            ? getCoachCategoryByServiceClass(coach)
            : getCoachCategoryByCoachType(coach),
        index,
    };

    preparedCoach.tariffsInfo = trainsSortCoachTariffs(coach.tariffsInfo);

    const {placesByType} = preparedCoach;

    if (!placesByType) {
        return {
            ...preparedCoach,
            placesByType: null,
        };
    }

    /**
     * хэш который по номеру места, выдаёт его тип (верхний, нижний)
     */
    const typeByPlaceNumber: Record<number, TrainPlaceType> = {};

    (Object.entries(placesByType) as [TrainPlaceType, number[]][]).forEach(
        ([type, places]) => {
            places.forEach(placeNumber => {
                typeByPlaceNumber[placeNumber] = type;
            });
        },
    );

    const preparedPlaces = preparedCoach.places.map(place => ({
        ...place,
        type: typeByPlaceNumber[place.number],
    }));

    return {
        ...preparedCoach,
        places: preparedPlaces,
        placesByType: null,
    };
}
