import {LANG} from 'constants/langCodes';
import {ETrainsPartner} from 'projects/trains/constants/trainPartners';

import IUserData from 'server/utilities/DataStorage/UserData/types/IUserData';
import {ITrainsGetTariffsApiParams} from 'server/api/TrainsApi/types/ITrainsGetTariffsApi/ITrainsGetTariffsApi';
import {ITrainsGetTariffsServiceParams} from 'server/services/TrainsService/types/ITrainsGetTariffsService/ITrainsGetTariffsService';

import boolify from 'utilities/boolean/boolify';

export default function prepareTrainsGetTariffsApiParams(
    params: ITrainsGetTariffsServiceParams,
    userData: IUserData,
): ITrainsGetTariffsApiParams {
    const poll = boolify(params.poll);

    const {language = LANG.RU} = params;

    return {
        ...params,
        language,
        poll,
        national_version: language,
        includePriceFee: '1',
        partner: ETrainsPartner.IM,
        useWizardSource: !poll,
        enableManyPlacesAtOnce: true,
        icookie: userData.getICookie(),
    };
}
