import ITrainsOrderInfoResponse from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoResponse';
import {
    ITrainsHpGenericOrder,
    ITrainsOrderDetails,
} from 'reducers/trains/order/types';

import {getTrainServicesByGenericOrderServices} from 'projects/trains/lib/order/getTrainServices';

const MIN_COUNT_COMPLEX_ORDER_SERVICES = 2;

export const prepareTrainsHpGenericOrderResponse = (
    order: ITrainsOrderInfoResponse,
): ITrainsHpGenericOrder => {
    return {
        id: order.id,
        prettyId: order.prettyId,
        status: order.status,
        customerInfo: {email: order.customerEmail, phone: order.customerPhone},
        services: getTrainServicesByGenericOrderServices(order.services),
    };
};

export const checkTrainsHpGenericOrderByOrderResponse = (
    order: ITrainsOrderInfoResponse,
): boolean => {
    return order.services?.length >= MIN_COUNT_COMPLEX_ORDER_SERVICES;
};

export const checkTrainsHpGenericOrder = (
    order?: ITrainsHpGenericOrder | ITrainsOrderDetails | null,
): order is ITrainsHpGenericOrder => {
    if (!order?.services?.length) {
        return false;
    }

    return order.services.length >= MIN_COUNT_COMPLEX_ORDER_SERVICES;
};
