import {ITrainsCoachServer} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';
import {ITrainsCoachCategory} from 'server/services/TrainsService/types/ITrainsDetailsInfoServiceResponse';

import getTariffClass from 'projects/trains/lib/getTariffClass';

/**
 * Функция возвращает категорию вагона по его типу.
 */
export default function getCoachCategoryByCoachType(
    coach: ITrainsCoachServer,
): ITrainsCoachCategory {
    return {
        value: coach.type,
        title: getTariffClass(coach.type),
    };
}
