import {ITrainsCoachServer} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';
import {ITrainsCoachCategory} from 'server/services/TrainsService/types/ITrainsDetailsInfoServiceResponse';

/**
 * Функция возвращает категорию вагона по его сервисному классу.
 */
export default function getCoachCategoryByServiceClass(
    coach: ITrainsCoachServer,
): ITrainsCoachCategory {
    return {
        value: coach.serviceClass.key,
        title: coach.serviceClass.title,
    };
}
