import uniq from 'lodash/uniq';
import map from 'lodash/map';

import {SITTING} from 'projects/trains/lib/segments/tariffs/constants';

import {ITrainsCoachServer} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import doAllCoachesHaveServiceClassTitle from 'projects/trains/lib/order/coaches/doAllCoachesHaveServiceClassTitle';

/**
 * Определяет необходимость использования классов обслуживания в качестве категорий вагонов
 *
 * @param coaches - массив вагонов
 */
export default function shouldUseServiceClassesAsCoachCategories(
    coaches: ITrainsCoachServer[],
): boolean {
    const coachesTypes = uniq(map(coaches, 'type'));

    return (
        coachesTypes.length === 1 &&
        coachesTypes[0] === SITTING &&
        doAllCoachesHaveServiceClassTitle(coaches)
    );
}
