import {Overwrite} from 'utility-types';

import {
    ITrainsCoachPlaceServer,
    ITrainsCoachServer,
    ITrainsDetailsServer,
    ITrainsSchema,
    TrainPlaceType,
} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import {IPartnerError} from 'projects/trains/lib/errors/orderErrors';

export interface ITrainsCoachCategory {
    value: string;
    title: string;
}

export interface ITrainsCoachPlace extends ITrainsCoachPlaceServer {
    type?: TrainPlaceType;
}

export interface ITrainsCoachApi
    extends Overwrite<
        ITrainsCoachServer,
        {
            placesByType: null;
            places: ITrainsCoachPlace[];
        }
    > {
    index: number;
    category: ITrainsCoachCategory;
}

export interface ITrainsDetailsApi
    extends Overwrite<
        ITrainsDetailsServer,
        {
            coaches: ITrainsCoachApi[];
            schemas: Record<number, ITrainsSchema>;
        }
    > {}

export interface ITrainsDetailsInfoServiceResponse {
    trainDetails: ITrainsDetailsApi | null;
    errors: boolean;
    partnerError: IPartnerError | null;
}
