import {LANG} from 'constants/langCodes';

import {
    ITrainsGetTariffsApiParams,
    ITrainsGetTariffsApiResponse,
} from 'server/api/TrainsApi/types/ITrainsGetTariffsApi/ITrainsGetTariffsApi';

export interface ITrainsGetTariffsServiceParams
    extends Pick<
        ITrainsGetTariffsApiParams,
        | 'startTime'
        | 'endTime'
        | 'pointFrom'
        | 'pointTo'
        | 'forceUfsOrder'
        | 'allowInternationalRoutes'
    > {
    language?: LANG;
    isMolly?: string;
    poll: string;
    when: string;
}

export interface ITrainsGetTariffsServiceResponse
    extends ITrainsGetTariffsApiResponse {}

export interface ITrainsGetTariffsService {
    (
        params: ITrainsGetTariffsServiceParams,
    ): Promise<ITrainsGetTariffsServiceResponse>;
}
