import {ETrainsPartner} from 'projects/trains/constants/trainPartners';

import {ITrainsDetailsApiParams} from 'server/api/TrainsApi/types/ITrainsDetailsApiParams';
import {ITrainsDetailsInfoServiceResponse} from 'server/services/TrainsService/types/ITrainsDetailsInfoServiceResponse';
import {IActivePartnersParams} from 'server/services/TrainsService/types/IActivePartnersParams';
import {Request} from '@yandex-data-ui/core/lib/types';
import {ITrainsOrderDetails} from 'reducers/trains/order/types';
import {
    ITrainsSaveOfferServiceParams,
    ITrainsSaveOfferServiceResponse,
} from 'server/services/TrainsService/types/ITrainsSaveOfferService';
import {ITrainsAddInsuranceServiceParams} from 'server/services/TrainsService/types/ITrainsAddInsuranceServiceParams';
import {ITrainsLogBanditApiParams} from 'server/api/TrainsApi/types/ITrainsLogBanditApiParams';
import {ITrainsSaveDocumentsAndTravelerToNotebookServiceParams} from 'server/services/TrainsService/types/ITrainsSaveDocumentsAndTravelerToNotebookServiceParams';
import ITrainsChangeRegistrationStatusParams from 'server/api/TrainsBookingApi/types/ITrainsChangeRegistrationStatusParams';
import ITrainsGetActualizedOrderServiceParams from 'server/services/TrainsService/types/ITrainsGetActualizedOrderServiceParams';
import ITrainsDownloadBlankApiParams from 'server/api/TrainsBookingApi/types/ITrainsDownloadBlankApiParams';
import {ITrainsGetSuggestsService} from 'server/services/TrainsService/types/ITrainsGetSuggestsService';
import {
    ITrainsTestContextTokenAnswer,
    ITrainsTestContextTokenParams,
} from 'server/api/TrainsBookingApi/types/ITrainsTestContextToken';
import {ITrainsGetFirmTrainService} from 'server/services/TrainsService/types/ITrainsGetFirmTrainService/ITrainsGetFirmTrainService';
import {ITrainsGetDirectionSearchService} from 'server/services/TrainsService/types/ITrainsGetDirectionSearchService/ITrainsGetDirectionSearchService';
import {ITrainsGetTariffsService} from 'server/services/TrainsService/types/ITrainsGetTariffsService/ITrainsGetTariffsService';

export interface ITrainsService {
    getSuggests: ITrainsGetSuggestsService;
    getTrainDetails(
        params: ITrainsDetailsApiParams,
    ): Promise<ITrainsDetailsInfoServiceResponse>;

    getTariffs: ITrainsGetTariffsService;

    activePartners(params: IActivePartnersParams): Promise<ETrainsPartner[]>;

    saveOffer(
        params: ITrainsSaveOfferServiceParams,
        req?: Request,
    ): Promise<ITrainsSaveOfferServiceResponse>;

    addInsurance(params: ITrainsAddInsuranceServiceParams): Promise<void>;

    logBandit(params: ITrainsLogBanditApiParams): Promise<void>;

    saveDocumentsAndTravelerToNotebook(
        params: ITrainsSaveDocumentsAndTravelerToNotebookServiceParams,
    ): Promise<void>;

    getActualizedTrainApiOrder(
        params: ITrainsGetActualizedOrderServiceParams,
    ): Promise<ITrainsOrderDetails>;

    downloadBlank(
        params: ITrainsDownloadBlankApiParams,
    ): Promise<NodeJS.ReadableStream>;

    changeOrderRegistrationStatus(
        params: ITrainsChangeRegistrationStatusParams,
    ): Promise<void>;

    testContextToken(
        params: ITrainsTestContextTokenParams,
    ): Promise<ITrainsTestContextTokenAnswer>;

    getFirmTrain: ITrainsGetFirmTrainService;
    getDirectionSearch: ITrainsGetDirectionSearchService;
}
