import {EFirmTrain} from 'types/trains/seoPages/firmTrain/TFirmTrainBlock';
import {ITrainsGetFirmTrainServiceResponse} from 'server/services/TrainsService/types/ITrainsGetFirmTrainService/ITrainsGetFirmTrainServiceResponse';

import getSapsanFirmTrainResponse200 from 'server/services/TrainsService/__mocks__/getSapsanFirmTrainResponse200';
import getStrizhFirmTrainResponse200 from 'server/services/TrainsService/__mocks__/getStrizhFirmTrainResponse200';
import getLastochkaFirmTrainResponse200 from 'server/services/TrainsService/__mocks__/getLastochkaFirmTrainResponse200';

const getFirmTrainMockResponseBySlug = ({
    slug,
}: {
    slug: EFirmTrain;
}): ITrainsGetFirmTrainServiceResponse => {
    switch (slug) {
        case EFirmTrain.LASTOCHKA: {
            return getLastochkaFirmTrainResponse200;
        }

        case EFirmTrain.SAPSAN: {
            return getSapsanFirmTrainResponse200;
        }

        case EFirmTrain.STRIZH: {
            return getStrizhFirmTrainResponse200;
        }
    }
};

export default getFirmTrainMockResponseBySlug;
