import ITripsService from 'server/services/TripsService/types/ITripsService';
import IGetTripResponse from 'server/api/TripsApi/types/IGetTripResponse';
import IGetTripRequestRequest from 'server/api/TripsApi/types/IGetTripRequestRequest';
import IGetActiveTripsApiResponse from 'server/api/TripsApi/types/IGetActiveTripsApiResponse';
import IGetTripsApiResponse from 'server/api/TripsApi/types/IGetTripsApiResponse';
import IGetMoreTripsApiResponse from 'server/api/TripsApi/types/IGetMoreTripsApiResponse';
import IGetMoreTripsRequest from 'server/services/TripsService/types/IGetMoreTripsRequest';
import IGetTripsRequest from 'server/services/TripsService/types/IGetTripsRequest';
import IGetTripAsyncBlocksRequest from 'server/api/TripsApi/types/IGetTripAsyncBlocksRequest';
import IGetTripAsyncBlocksResponse from 'server/api/TripsApi/types/IGetTripAsyncBlocksResponse';

import {IDependencies} from 'server/getContainerConfig';
import {TripsApi} from 'server/api/TripsApi/TripsApi';
import {GeobaseService} from 'server/services/GeobaseService/GeobaseService';

export class TripsService implements ITripsService {
    tripsApi: TripsApi;
    geobaseService: GeobaseService;

    constructor({tripsApi, geobaseService}: IDependencies) {
        this.tripsApi = tripsApi;
        this.geobaseService = geobaseService;
    }

    async getActiveTrips(): Promise<IGetActiveTripsApiResponse> {
        return this.tripsApi.getActiveTrips({
            userGeoId: await this.getUserGeoId(),
        });
    }

    async getTrips(params: IGetTripsRequest): Promise<IGetTripsApiResponse> {
        return this.tripsApi.getTrips({
            userGeoId: await this.getUserGeoId(),
            pastLimit: params.pastLimit,
        });
    }

    async getMoreTrips(
        params: IGetMoreTripsRequest,
    ): Promise<IGetMoreTripsApiResponse> {
        return this.tripsApi.getMoreTrips({
            userGeoId: await this.getUserGeoId(),
            continuationToken: params.continuationToken,
            limit: params.limit,
        });
    }

    getTrip(params: IGetTripRequestRequest): Promise<IGetTripResponse> {
        return this.tripsApi.getTrip(params);
    }

    getTripAsyncBlock(
        params: IGetTripAsyncBlocksRequest,
    ): Promise<IGetTripAsyncBlocksResponse> {
        return this.tripsApi.getTripAsyncBlocks(params);
    }

    private async getUserGeoId(): Promise<number> {
        const {geoId} = await this.geobaseService.getUserGeoLocation();

        return geoId;
    }
}
