import {IGetForecastByGeoIdParams} from 'server/api/WeatherApi/types/IGetForecastByGeoIdParams';
import {IGetForecastByGeoIdResponse} from 'server/api/WeatherApi/types/IGetForecastByGeoIdResponse';

import {WeatherApi} from 'server/api/WeatherApi/WeatherApi';
import {IDependencies} from 'server/getContainerConfig';

export interface IWeatherService {
    getWeatherForecastByGeoId(
        params: IGetForecastByGeoIdParams,
    ): Promise<IGetForecastByGeoIdResponse>;
}

export class WeatherService implements IWeatherService {
    private weatherApi: WeatherApi;

    constructor({weatherApi}: IDependencies) {
        this.weatherApi = weatherApi;
    }

    getWeatherForecastByGeoId(
        params: IGetForecastByGeoIdParams,
    ): Promise<IGetForecastByGeoIdResponse> {
        return this.weatherApi.getWeatherForecastByGeoId(params);
    }
}
