import {EWhiteLabelPartner} from 'types/common/whiteLabel/EWhiteLabelPartner';
import {IWhiteLabelService} from 'server/services/WhiteLabelService/types/IWhiteLabelService';
import {IWhiteLabelConfig} from 'types/common/whiteLabel/IWhiteLabelConfig';

import {WHITE_LABEL_S7_CONFIG} from 'projects/whiteLabel/configs/s7.config';

export class WhiteLabelService implements IWhiteLabelService {
    async getConfigByName(
        partner: EWhiteLabelPartner,
    ): Promise<IWhiteLabelConfig | null> {
        switch (partner) {
            case EWhiteLabelPartner.S7:
                return WHITE_LABEL_S7_CONFIG;
            default:
                return null;
        }
    }
}
