export interface IApiErrorMessage {
    error: string;
    requestBody?: string;
    response?: string;
}

export default class AviaBackendApiError extends Error {
    constructor(err: any, requestBody: any, response: string) {
        super();
        this.name = this.constructor.name;

        const msg = err instanceof Error ? err.message : err;

        const message = {
            error: msg,
        } as IApiErrorMessage;

        if (requestBody) {
            message.requestBody = requestBody;
        }

        if (response) {
            message.response = JSON.parse(response);
        }

        this.message = JSON.stringify(message);
    }
}
