import {pick} from 'lodash';

import {AFFILIATE_COOKIE_NAME} from 'constants/affiliate/cookieName';

import {ICookies} from '@yandex-data-ui/core/lib/types';
import {IAffiliateParams} from 'types/affiliate/IAffiliateParams';
import {AFFILIATE_FIELDS} from 'types/affiliate/EAffiliateField';

import {IDependencies} from 'server/getContainerConfig';

export default class AffiliateData {
    private readonly cookies: ICookies;

    constructor({cookies}: IDependencies) {
        this.cookies = cookies;
    }

    getParams(): IAffiliateParams {
        try {
            const affiliateData = this.cookies[AFFILIATE_COOKIE_NAME];

            return affiliateData
                ? pick(JSON.parse(affiliateData), AFFILIATE_FIELDS)
                : {};
        } catch (e) {
            return {};
        }
    }
}
