import {EAttributionQueryParams} from 'constants/attribution/queryParams';

import EAttributionField from 'types/attribution/EAttributionField';

import {
    WIZARD_FLAGS_QUERY_NAMES,
    WIZARD_REDIR_KEY_QUERY_NAMES,
    WIZARD_REQ_ID_QUERY_NAMES,
} from 'utilities/url/wizard/wizardQueryNames';

/**
 * Сопоставляет наши поля аттрибуции и query параметры, берет первый подходящий
 */
const mapFieldToQuery: Record<EAttributionField, string[]> = {
    [EAttributionField.UTM_SOURCE]: [EAttributionQueryParams.UTM_SOURCE],
    [EAttributionField.UTM_MEDIUM]: [EAttributionQueryParams.UTM_MEDIUM],
    [EAttributionField.UTM_CAMPAIGN]: [EAttributionQueryParams.UTM_CAMPAIGN],
    [EAttributionField.UTM_TERM]: [EAttributionQueryParams.UTM_TERM],
    [EAttributionField.UTM_CONTENT]: [EAttributionQueryParams.UTM_CONTENT],

    [EAttributionField.GCLID]: [EAttributionQueryParams.GCLID],
    [EAttributionField.YCLID]: [EAttributionQueryParams.YCLID],
    [EAttributionField.FBCLID]: [EAttributionQueryParams.FBCLID],
    [EAttributionField.YTP_REFERER]: [EAttributionQueryParams.YTP_REFERER],

    [EAttributionField.SERP_REQ_ID]: [
        ...WIZARD_REQ_ID_QUERY_NAMES,
        EAttributionQueryParams.SERP_REQ_ID,
        EAttributionQueryParams.REQ_ID,
    ],
    [EAttributionField.SERP_UUID]: [EAttributionQueryParams.SERP_UUID],
    [EAttributionField.SERP_TEST_ID]: [
        EAttributionQueryParams.TEST_ID,
        EAttributionQueryParams.SERP_TEST_ID,
    ],
    [EAttributionField.FROM]: [EAttributionQueryParams.FROM],

    [EAttributionField.WIZARD_FLAGS]: [...WIZARD_FLAGS_QUERY_NAMES],
    [EAttributionField.WIZARD_REDIR_KEY]: [...WIZARD_REDIR_KEY_QUERY_NAMES],

    [EAttributionField.USER_REGION]: [EAttributionQueryParams.USER_REGION],
};

export default mapFieldToQuery;
