/* eslint-disable camelcase */
import IUserDataValues from 'server/utilities/DataStorage/UserData/types/IUserDataValues';
import IUserData from 'server/utilities/DataStorage/UserData/types/IUserData';
import {Platform} from 'types/Platform';

import getPlatform from 'utilities/deviceType/getPlatform';

import {IDependencies} from 'server/getContainerConfig';

/**
 * Хранилище нелипких позапросных пользовательских данных
 */
export default class UserData implements IUserData {
    private data: IUserDataValues = {
        deviceType: Platform.DESKTOP,
    };

    constructor(dependencies: IDependencies) {
        const {cookies, uatraits, yandexuid, userInfo, ip} = dependencies;

        this.data.iCookie = cookies.i;
        this.data.yandexUid = yandexuid;
        this.data.passportId =
            userInfo && 'uid' in userInfo ? userInfo.uid : undefined;
        this.data.ip = ip;
        this.data.deviceType = getPlatform(uatraits.isMobile);
        this.data.metrikaClientId = cookies['_ym_uid'];
    }

    getICookie(): string | undefined {
        return this.data.iCookie;
    }

    getYandexUid(): string | undefined {
        return this.data.yandexUid;
    }

    getPassportId(): string | undefined {
        return this.data.passportId;
    }

    getIp(): string | undefined {
        return this.data.ip;
    }

    getMetrikaClientId(): string | undefined {
        return this.data.metrikaClientId;
    }

    /**
     * Используем yuid в метрике как UserId
     */
    getMetrikaUserId(): string | undefined {
        return this.data.yandexUid;
    }

    getDeviceType(): Platform {
        return this.data.deviceType;
    }
}
