import {IAxiosRetryConfig} from 'axios-retry';
import {AxiosRequestConfig} from 'axios';

/**
 * Совместимый с axios интерфейс http-клиента
 */
export interface IRequestConfig extends AxiosRequestConfig {
    id?: string;
    convertResponseKeysToCamelCase?: boolean;
    withStatus?: boolean;
    axiosRetry?: IAxiosRetryConfig;
}

export interface IResponse<T = void> {
    data: T;
    status: number;
    statusText: string;
    headers: any;
}

export interface IErrorResponse extends Error {
    code?: string;
    request?: any;
    response?: IResponse<any>;
}

export interface IHttpClient {
    request<T = any>(config: IRequestConfig): Promise<IResponse<T>>;
}
