export function isBadRequestError(error: unknown): boolean {
    return isUnescapedCharactersError(error);
}

/**
 * https://nodejs.org/api/errors.html#errors_err_unescaped_characters
 *
 * Происходит, когда мы отправляем запрос из nodejs на урл с плохими символами
 */
function isUnescapedCharactersError(error: unknown): boolean {
    return (
        error instanceof TypeError &&
        (error as any).code === 'ERR_UNESCAPED_CHARACTERS'
    );
}
