import {TErrorLogger, ILogger, TLogger} from './ILogger';

export interface ILoggerConstructorParams {
    log: TLogger;
    logWarn: TErrorLogger;
    logError: TErrorLogger;
    extra?: any;
}

export class AppLogger implements ILogger {
    protected readonly _log: TLogger;

    protected readonly _logError: TErrorLogger;

    protected readonly _logWarn: TErrorLogger;

    private readonly _extra?: any;

    constructor({log, logError, logWarn, extra}: ILoggerConstructorParams) {
        this._log = log;
        this._logError = logError;
        this._logWarn = logWarn;
        this._extra = extra;
    }

    log(message: string, extra: any): void {
        this._log(message, this.getExtra(extra));
    }

    logWarn(message: string, error?: Error, extra?: any): void {
        this._logWarn(message, error, this.getExtra(extra));
    }

    logError(message: string, error?: Error, extra?: any): void {
        this._logError(message, error, this.getExtra(extra));
    }

    addExtra<T extends {}>(extra: T): void {
        Object.assign(this._extra, extra);
    }

    protected getExtra(extra: any = {}): object {
        return Object.assign({}, this._extra, extra);
    }
}
