import _ from 'lodash';

import {AppRequestHandler} from '@yandex-data-ui/core/lib/types';

import {resolveContainerValue} from 'server/utilities/container/resolve';

export function logAction(
    target: any,
    propertyKey: string | symbol,
    descriptor: TypedPropertyDescriptor<AppRequestHandler>,
): void {
    const originalFn = descriptor.value;

    if (typeof originalFn !== 'function') {
        throw new TypeError('logAction can only decorate functions');
    }

    descriptor.value = function (req, res): void | Promise<void> {
        const logger = resolveContainerValue(req.container, 'logger');
        const className = _.get(target, 'constructor.name');

        logger.addExtra({
            controller: className,
            action: propertyKey.toString(),
        });

        return originalFn.call(this, req, res);
    };
}
