import {
    Request,
    Response,
    CoreRequestHandler,
} from '@yandex-data-ui/core/lib/types';

type TApiMethods = 'GET' | 'DELETE' | 'POST' | 'PUT' | 'PATCH';

export default (requestMethod: TApiMethods) => {
    return function (
        target: any,
        propertyKey: string | symbol,
        descriptor: TypedPropertyDescriptor<CoreRequestHandler>,
    ): void {
        const originalFn = descriptor.value;

        if (typeof originalFn !== 'function') {
            throw new TypeError('requestMethod can decorate only functions');
        }

        descriptor.value = function (
            req: Request,
            res: Response,
        ): void | Promise<void> {
            const {method} = req;

            if (requestMethod === method) {
                return originalFn.call(this, req, res);
            }

            res.status(405).send();
        };
    };
};
