import {
    Request,
    Response,
    CoreRequestHandler,
} from '@yandex-data-ui/core/lib/types';

export default function requiredParams(params: string[]) {
    return function (
        target: any,
        propertyKey: string | symbol,
        descriptor: TypedPropertyDescriptor<CoreRequestHandler>,
    ): void {
        const originalFn = descriptor.value;

        if (typeof originalFn !== 'function') {
            throw new TypeError('requiredParams can decorate only functions');
        }

        descriptor.value = function (
            req: Request,
            res: Response,
        ): void | Promise<void> {
            const missingParams = params.filter(x => !req.query[x]);

            if (missingParams.length > 0) {
                res.status(400).send({
                    message: 'Missing required params',
                    missing: missingParams,
                });
            } else {
                return originalFn.call(this, req, res);
            }
        };
    };
}
