const EATH_RADIUS_METRE = 6371009; // Средний радиус земли в метрах
const EATH_RADIUS_KILOMETRE = EATH_RADIUS_METRE / 1000;
const DEG_IN_RAD = 180.0 / Math.PI;

export interface ICoordinate {
    longitude: number;
    latitude: number;
}

export function greatCircleDistanceKm(
    point1: ICoordinate,
    point2: ICoordinate,
): number {
    return EATH_RADIUS_KILOMETRE * greatCircleAngularDistance(point1, point2);
}

function greatCircleAngularDistance(
    point1: ICoordinate,
    point2: ICoordinate,
): number {
    const latitude1Rad = point1.latitude / DEG_IN_RAD;
    const longitude1Rad = point1.longitude / DEG_IN_RAD;

    const latitude2Rad = point2.latitude / DEG_IN_RAD;
    const longitude2Rad = point2.longitude / DEG_IN_RAD;

    const longitudeDelta = longitude2Rad - longitude1Rad;
    const numerator = Math.sqrt(
        (Math.cos(latitude2Rad) * Math.sin(longitudeDelta)) ** 2 +
            (Math.cos(latitude1Rad) * Math.sin(latitude2Rad) -
                Math.sin(latitude1Rad) *
                    Math.cos(latitude2Rad) *
                    Math.cos(longitudeDelta)) **
                2,
    );

    const denominator =
        Math.sin(latitude1Rad) * Math.sin(latitude2Rad) +
        Math.cos(latitude1Rad) *
            Math.cos(latitude2Rad) *
            Math.cos(longitudeDelta);

    return Math.atan2(numerator, denominator);
}
