/**
 * @typedef {import('@yandex-data-ui/core/lib/types').Request} Request
 */

/**
 * @param {Request} req
 * @returns {boolean}
 */
function fromYandex(req) {
    const {isStaff} = req.userInfo || {};
    const {isYandexNetwork} = req.userInfo || {};

    return isStaff || isYandexNetwork || process.env.APP_ENV !== 'production';
}

module.exports = {
    fromYandex,
};
