import get from 'lodash/get';

import {BlackboxInfo} from '@yandex-data-ui/core/lib/types';

export function getBlackboxDefaultPhone(
    blackbox: BlackboxInfo,
): string | undefined {
    const {default_uid: uid, users = []} = blackbox?.raw ?? {};
    const user = users.find(item => item.id === uid);

    return get(user, 'phones[0].attributes[1]');
}
