import {ChunkExtractor} from '@loadable/server';
import fs from 'fs-extra';

import getUrlWithUpdatedQuery from 'utilities/url/getUrlWithUpdatedQuery';

export default function getCriticalCss(extractor: ChunkExtractor): string {
    const mainAssets = extractor.getMainAssets('style');

    /*
     * На ферме в названии файла в файловой системе нету суффикса farmId,
     * поэтому его нужно убрать руками, чтобы получить правильный путь до файла
     */
    const mainAssetsWithoutFarmQuery =
        process.env.APP_ENV === 'beta'
            ? mainAssets.map(asset => ({
                  ...asset,
                  path: getUrlWithUpdatedQuery(asset.path, {farmId: undefined}),
              }))
            : mainAssets;

    return mainAssetsWithoutFarmQuery
        .map(asset => fs.readFileSync(asset.path))
        .join('\n');
}
