import {
    WHITE_LABEL_REGEXP,
    WHITE_LABEL_AVAILABLE_PARTNERS,
} from 'server/constants/whiteLabel';

import {Request} from '@yandex-data-ui/core/lib/types';
import {EWhiteLabelPartner} from 'types/common/whiteLabel/EWhiteLabelPartner';

function getWhiteLabelPartnerFromReq(req: Request): EWhiteLabelPartner | null {
    const match = req.hostname.match(WHITE_LABEL_REGEXP);

    if (match === null) {
        return null;
    }

    const partner = match[1] as EWhiteLabelPartner;
    const isAvailablePartner = WHITE_LABEL_AVAILABLE_PARTNERS.includes(partner);

    if (!isAvailablePartner) {
        return null;
    }

    return partner;
}

export default getWhiteLabelPartnerFromReq;
