import path from 'path';
import {ChunkExtractor} from '@loadable/server';

import {serverBuildPath} from '../../../webpack/utilities/getPathParams';

import {clientWebpackConfig} from '../../../webpack/client.webpack.config';

export const getChunkExtractor = (
    entryPoints: (keyof typeof clientWebpackConfig.entry)[],
): ChunkExtractor => {
    const statsFile = path.resolve(serverBuildPath, 'loadable-stats.json');

    const withDockerImage =
        process.env.APP_ENV === 'testing' ||
        process.env.APP_ENV === 'production';

    return new ChunkExtractor({
        statsFile,
        entrypoints: entryPoints,
        /*
         * При сборке Docker образа, клиентский webpack собирается в папке /tmp/app/build/client и потом перекладывается в папку /opt/app/build/client,
         * но в loadable-stats.json outputPath остается /tmp/app/build/client. Перезаписываем, чтобы получить правильный путь до файлов.
         */
        ...(withDockerImage
            ? {
                  outputPath: '/opt/app/build/client',
              }
            : {}),
    });
};
