import getProjectName from '../getProjectName';

interface IMetrikaWebvisorConfig {
    inclusionPercent: {
        projects: {
            [projectName: string]: number;
        };
        defaultPercent: number;
    };
}

function getPercent(url: string, config: IMetrikaWebvisorConfig): number {
    const projectName = getProjectName(url);

    const {
        inclusionPercent: {projects, defaultPercent},
    } = config;

    return projects[projectName] ?? defaultPercent;
}

export default function webvisorIsEnabled(
    url: string,
    config: Nullable<IMetrikaWebvisorConfig>,
): boolean {
    if (!config) {
        return true;
    }

    const percent = getPercent(url, config);

    return Math.random() <= percent;
}
