import {StaticRouterContext} from 'react-router';

import {Response} from '@yandex-data-ui/core/lib/types';

export function responseByRouterContext(
    res: Response,
    routerContext: StaticRouterContext,
    html: string,
): Response | void {
    if (routerContext.url) {
        return res.redirect(routerContext.url, routerContext.statusCode || 301);
    }

    if (routerContext.statusCode) {
        res.status(routerContext.statusCode);
    }

    return res.send(html);
}
