import {ParsedQuery} from 'query-string';

import {TSrcParams} from 'types/TSourceParams';
import {isEApiEntry} from 'types/EApiEntry';

export function parseSrcParams(query: ParsedQuery): TSrcParams {
    const rawParam = query.srcParams;

    if (!rawParam) {
        return {};
    }

    const srcParams = Array.isArray(rawParam) ? rawParam[0] : rawParam;

    return srcParams.split(',').reduce<TSrcParams>((acc, item) => {
        const [source, param] = item.split(':');
        const [key, value] = param.split('=');

        if (!isEApiEntry(source)) {
            return acc;
        }

        const target = acc[source];

        if (target) {
            target[key] = value;
        } else {
            acc[source] = {
                [key]: value,
            };
        }

        return acc;
    }, {});
}
