const _ = require('lodash');

const decodeWin1251URI = require('./decodeWin1251URI');

/**
 * Декодирует URL, который испорчен после пересылки через ВК. Потенциально можно
 * выпилить, когда ВК пофиксит проблему
 *
 * FYI: Ресерч показал, что в ссылке:
 * 1. Заменяются амперсанды и прочие спец. символы на их HTML-альтернативы, например & -> &amp;
 * 2. Русские символы в URL кодируются в percent-encoding с кодировкой WIN-1251, хотя стандартно используется UTF-8
 * @see https://vk.com/bug321165
 *
 * @param {string} path
 * @returns {string}
 */

function urlDecode(path) {
    // Чистим от конструкций вида /?a=1&amp;b=2
    const htmlUnescapedPath = _.unescape(path);

    if (!htmlUnescapedPath.includes('%')) {
        return htmlUnescapedPath;
    }

    // Дополнительно пытаемся проверить, что url может быть декодирован через decodeURI
    // Если да, сервер сам с ним справится
    // Если нет, возможно стоит попробовать декодировать с кодировкой win-1251

    try {
        decodeURI(htmlUnescapedPath);

        return htmlUnescapedPath;
    } catch (e) {
        return decodeWin1251URI(htmlUnescapedPath);
    }
}

module.exports = urlDecode;
