/**
 * @typedef {import('../../../utilities/utm/constants/queryMarks').EAviaSpecificQueryMarks} EAviaSpecificQueryMarks
 */

import {EAviaQueryMarks} from 'server/utilities/utm/constants/queryMarks';

const {
    WIZARD_FLAGS_QUERY_NAMES,
    WIZARD_REQ_ID_QUERY_NAMES,
} = require('utilities/url/wizard/wizardQueryNames');

/** @type {EAviaSpecificQueryMarks[]} */
const FIELDS_TO_VALIDATE = [
    EAviaQueryMarks.CLID,
    EAviaQueryMarks.STID,
    ...WIZARD_FLAGS_QUERY_NAMES,
    EAviaQueryMarks.SERP_UUID,
    ...WIZARD_REQ_ID_QUERY_NAMES,
];

module.exports = function logInvalidQueryTypes(req) {
    const {query, utils} = req;

    FIELDS_TO_VALIDATE.forEach(field => {
        if (Array.isArray(query[field])) {
            utils.logWarn(`Unexpected array type of utm label "${field}"`);
        }
    });
};
