const {
    UTM_QUERY_PARAMS,
} = require('../../../../src/constants/utm/EUtmQueryParams');

/**
 * @param {Record<string, string>} query
 * @returns {IUtmQueryParams}
 */
module.exports = function (query) {
    return UTM_QUERY_PARAMS.reduce((utms, k) => {
        const val = query[k];

        if (val) {
            utms[k] = Array.isArray(val) ? val.join(',') : val;
        }

        return utms;
    }, {});
};
