/**
 * @typedef {import('@yandex-data-ui/core/lib/types').Response} Response
 */

const getCookieParams = require('./getCookieParams');

/**
 * @param {Response} res
 * @param {string} queryValue
 * @param {string} cookieValue
 * @param {string} name
 * @param {number} days
 * @returns {void}
 */
module.exports = function (res, queryValue, cookieValue, name, days) {
    if (queryValue) {
        res.aviaCookie(name, queryValue, getCookieParams(days));
    } else if (cookieValue) {
        res.aviaClearCookie(name);
    }
};
