import {Meta} from '@storybook/react/types-6-0';
import {useRef} from 'react';

import {TStorybookFunctionComponent} from 'storybook/types';

import {useBoolean} from 'utilities/hooks/useBoolean';

import LinkButton from 'components/LinkButton/LinkButton';
import Text from 'components/Text/Text';
import Details from 'icons/24/Details';
import DownloadIcon from 'icons/24/Download';
import CheckIcon from 'icons/24/Check';

import ActionsDialog from './ActionsDialog';

export default {
    title: 'Example/ActionsDialog',
    component: ActionsDialog,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const ref = useRef(null);
    const {value, setTrue, setFalse} = useBoolean(false);

    return (
        <>
            <LinkButton innerRef={ref} onClick={setTrue}>
                Дополнительные действия
            </LinkButton>
            <ActionsDialog
                isOpened={value}
                onClose={setFalse}
                iconSize={24}
                buttonRef={ref}
                actions={[
                    {
                        id: 'details',
                        title: 'Детали заказа',
                        icon: Details,
                        onClick: (): void => {
                            console.log('CLICK: "Детали заказа"');
                        },
                    },
                    {
                        id: 'receipts',
                        title: 'Чек на платеж',
                        icon: CheckIcon,
                        onClick: (): void => {
                            console.log('CLICK: "Чек на платеж"');
                        },
                    },
                    {
                        id: 'receipts-loading',
                        title: 'Загрузка чека',
                        icon: CheckIcon,
                        loading: true,
                        onClick: (): void => {
                            console.log('CLICK: "Загрузка чека на платеж"');
                        },
                    },
                    {
                        id: 'docs',
                        title: 'Отчетность для бухгалтерии',
                        icon: DownloadIcon,
                        disabled: true,
                        description: (
                            <Text size="inherit" color="alert">
                                Документ для бухгалтерии будет доступен на
                                следующий день после выселения
                            </Text>
                        ),
                        onClick: (): void => {
                            console.log('CLICK: "Отчетность для бухгалтерии"');
                        },
                    },
                ]}
            />
        </>
    );
};

Simple.parameters = {
    info: {
        title: 'Компонент для выбора действий из списка - в таче это BottomSheet, в десктопе попап',
    },
};
