import React, {MouseEvent, RefObject, useRef} from 'react';

import IActionItem from '../../types/IActionItem';
import EPopupDirection from 'components/Popup/types/EPopupDirection';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Popup from 'components/Popup/Popup';
import ActionItem from 'components/ActionsDialog/components/ActionItem/ActionItem';
import {TIconSize} from 'components/TextWithIcon/TextWithIcon';

import cx from './DesktopActionsDialog.scss';

const DIRECTIONS = [EPopupDirection.BOTTOM_RIGHT, EPopupDirection.TOP_RIGHT];

interface IDesktopActionsDialogProps extends IWithQaAttributes {
    actions: IActionItem[];
    isOpened: boolean;
    buttonRef: RefObject<HTMLElement>;
    directions?: EPopupDirection[];
    secondaryOffset?: number;
    iconSize?: TIconSize;
    onItemClick(event: MouseEvent, action: IActionItem): void;
    onClose(): void;
}

const DesktopActionsDialog: React.FC<IDesktopActionsDialogProps> = props => {
    const {
        actions,
        buttonRef,
        isOpened,
        directions = DIRECTIONS,
        secondaryOffset,
        iconSize,
        onItemClick,
        onClose,
    } = props;

    const popupContentRef = useRef<HTMLDivElement>(null);

    return (
        <Popup
            anchor={buttonRef}
            visible={isOpened}
            hasTail={false}
            directions={directions}
            onClose={onClose}
            targetRef={popupContentRef}
            secondaryOffset={secondaryOffset}
        >
            <div
                ref={popupContentRef}
                className={cx('root')}
                {...prepareQaAttributes(props)}
            >
                {actions.map(action => (
                    <ActionItem
                        key={action.id}
                        item={action}
                        iconSize={iconSize}
                        onClick={onItemClick}
                        {...prepareQaAttributes({
                            parent: props,
                            key: action.id,
                            current: 'actionItem',
                        })}
                    />
                ))}
            </div>
        </Popup>
    );
};

export default DesktopActionsDialog;
