import React from 'react';

import IActionItem from '../../types/IActionItem';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Flex from 'components/Flex/Flex';
import BottomSheet from 'components/BottomSheet/BottomSheet';
import {TIconSize} from 'components/TextWithIcon/TextWithIcon';

import ActionItem from '../ActionItem/ActionItem';

interface IMobileActionsDialogProps extends IWithQaAttributes {
    actions: IActionItem[];
    isOpened: boolean;
    iconSize?: TIconSize;
    onItemClick(event: React.MouseEvent, action: IActionItem): void;
    onClose(): void;
}

const MobileActionsDialog: React.FC<IMobileActionsDialogProps> = props => {
    const {actions, isOpened, iconSize, onClose, onItemClick} = props;

    return (
        <BottomSheet
            popHistoryOnUnmount={false}
            isOpened={isOpened}
            onClose={onClose}
        >
            <Flex
                flexDirection="column"
                justifyContent="stretch"
                {...prepareQaAttributes(props)}
            >
                {actions.map(action => (
                    <ActionItem
                        key={action.id}
                        item={action}
                        iconSize={iconSize}
                        onClick={onItemClick}
                        {...prepareQaAttributes({
                            parent: props,
                            key: action.id,
                            current: 'actionItem',
                        })}
                    />
                ))}
            </Flex>
        </BottomSheet>
    );
};

export default MobileActionsDialog;
