import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import * as i18nBlock from 'i18n/avia-AviaAdvantages';

import AviaCompare from 'icons/illustrations/AviaCompare/AviaCompareM';
import AviaSearch from 'icons/illustrations/AviaSearch/AviaSearchM';
import Choices from 'icons/illustrations/Choices/ChoicesM';
import SubscribeAvia from 'icons/illustrations/SubscribeAvia/SubscribeAviaM';
import Text from 'components/Text/Text';

import Advantages from './Advantages';

export default {
    title: 'Example/Advantages',
    component: Advantages,
} as Meta;

const advantages = [
    {
        title: i18nBlock.aviaAdvantageCompareTitle(),
        description: i18nBlock.aviaAdvantageCompareDescription(),
        IconComponent: AviaCompare,
        iconWidth: 179,
        iconHeight: 120,
    },
    {
        title: i18nBlock.aviaAdvantageSearchTitle(),
        description: i18nBlock.aviaAdvantageSearchDescription(),
        IconComponent: AviaSearch,
        iconWidth: 174,
        iconHeight: 120,
    },
    {
        title: i18nBlock.aviaAdvantageChoiceTitle(),
        description: i18nBlock.aviaAdvantageChoiceDescription(),
        IconComponent: Choices,
        iconWidth: 157,
        iconHeight: 120,
    },
    {
        title: i18nBlock.aviaAdvantageSubscribeTitle(),
        description: i18nBlock.aviaAdvantageSubscribeDescription(),
        IconComponent: SubscribeAvia,
        iconWidth: 120,
        iconHeight: 120,
    },
];

export const Simple: TStorybookFunctionComponent = () => (
    <Advantages advantages={advantages} />
);

Simple.parameters = {
    info: {
        title: 'Преимущества',
    },
};

export const Flat: TStorybookFunctionComponent = () => (
    <Advantages
        advantages={advantages}
        title={
            <Text size="xxl" weight="fat">
                <Text size="inherit">Почему мы</Text>{' '}
                <Text size="inherit" weight="fat">
                    классные
                </Text>
            </Text>
        }
    />
);

Flat.parameters = {
    info: {
        title: 'Преимущества в плоском дизайне',
    },
};
