import {ReactNode, FunctionComponent, memo, ComponentType} from 'react';

import {IWithClassName} from 'types/withClassName';
import IIconAdvantageProps from 'components/Advantages/types/IIconAdvantageProps';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Heading from 'components/Heading/Heading';
import Box from 'components/Box/Box';
import {TTextSize} from 'components/Text/Text';

import cx from './Advantage.scss';

interface IAdvantageProps extends IWithClassName, IWithQaAttributes {
    title?: string;
    description: ReactNode;
    IconComponent: ComponentType<IIconAdvantageProps>;
    iconWidth: number;
    iconHeight: number;
    descriptionTextSize?: TTextSize;
}

const Advantage: FunctionComponent<IAdvantageProps> = props => {
    const {
        className,
        title,
        description,
        IconComponent,
        iconWidth,
        iconHeight,
        descriptionTextSize = 's',
    } = props;

    const deviceType = useDeviceType();

    return (
        <div
            className={cx('root', deviceMods('root', deviceType), className)}
            {...prepareQaAttributes(props)}
        >
            <IconComponent
                width={iconWidth}
                height={iconHeight}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'icon',
                })}
            />

            {title && (
                <Heading
                    className={cx('title')}
                    level="3"
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'title',
                    })}
                >
                    {title}
                </Heading>
            )}

            <Box
                above={2}
                textSize={descriptionTextSize}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'description',
                })}
            >
                {description}
            </Box>
        </div>
    );
};

export default memo(Advantage);
