import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nRebranding from 'i18n/index-Advantages';

import Text from 'components/Text/Text';

import cx from './AdvantagesTitle.scss';

interface IAdvantagesTitleProps extends IWithClassName {
    baseText: (params: {boldText: number | string | boolean}) => string;
}

const AdvantagesTitle: React.FC<IAdvantagesTitleProps> = props => {
    const {className, baseText} = props;

    const deviceType = useDeviceType();

    return (
        <Text
            className={cx(className, 'root')}
            tag="h1"
            size={deviceType.isDesktop ? 'xxl' : 'xl'}
        >
            {insertJSXIntoKey(baseText)({
                boldText: (
                    <Text size="inherit" weight="fat">
                        {deviceType.isDesktop
                            ? i18nRebranding.commonTitleBold()
                            : i18nRebranding.commonTitleBoldShort()}
                    </Text>
                ),
            })}
        </Text>
    );
};

export default React.memo(AdvantagesTitle);
